/*
 * 听悟大模型前端项目 - 应用主组件
 * Copyright (C) 2024 听悟项目贡献者
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

import React from "react";
import { Routes, Route } from "react-router-dom";
import { Layout } from "antd";
import { RootContainer } from "@tingwujs/summary";

import { ExperienceCenter } from "@tingwujs/home";

const App: React.FC = () => {
  return (
    <Layout style={{ height: "100vh" }}>
      <Routes>
        <Route path="/" element={<ExperienceCenter />} />
        <Route
          path="/details/:id"
          element={
            <div style={{ width: "100%", height: "100vh" }}>
              <RootContainer />
            </div>
          }
        />
      </Routes>
    </Layout>
  );
};

export default App;
