import React from "react";
import { Tooltip as AntdTooltip, TooltipProps } from "antd";
import classNames from "classnames";
import { customClsName } from "./styled";
// import { myRoot } from '../../../util/constant';

export const Tooltip = (props: TooltipProps) => {
  return (
    <AntdTooltip
      {...props}
      getTooltipContainer={() =>
        document.querySelector(".appRoot") ||
        document.getElementById("root") ||
        (document.body as any)
      }
      overlayClassName={classNames(customClsName, props.className)}
    />
  );
};

Object.assign(Tooltip, AntdTooltip);
