import { createGlobalStyle } from "styled-components";

export const tyPopoverCls = "ty-selec";
export const tyPopoverDropdownCls = "ty-select-dropdown";

export const SelectInjectStyle = createGlobalStyle`body, html {
  ${`.${tyPopoverCls}`} {
    .ant-select-selector {
      padding: 0 12px;
      height: 100%;
      border-radius: 8px !important;
      background: var(--Fill_Background_Light) !important;
      color: var(--Text_Primary) !important;
      border: 1px solid var(--Line_Brand_Secondary) !important;
      box-shadow: none !important;
      .ant-select-selection-search-input input {
        font-size: 14px;
        color: var(--Text_Primary);;
      }
      .ant-select-selection-item {
        font-family: PingFangSC, var(--font-family);
        font-size: 14px;
        color: var(--Text_Primary);
      }
    }


    .ant-select-item.ant-select-item-option {
      height: 36px;
      padding: 6px 12px;
      line-height: 36px;
      font-family: PingFangSC, var(--font-family);
      font-size: 14px;
      color: var(--Text_Primary) !important;
    }
    .ant-select-selection-item {
      .PanelBodyCompo__Option {
        height: 36px;
        line-height: 36px;
        padding-left: 0;
      }
    }
    .ant-select-focused::not(.ant-select-disabled):not(
        .ant-select-customize-input
      ):not(.ant-pagination-size-changer)
      .ant-select-selector {
      box-shadow: none;
      border-color: var(--Line_Heavy);
    }
    
    &:hover {
      .ant-select-selector{
        border-color: var(--Text_Primary) !important;
      }
    }
  }}
`;

export const SelectDropdownInjectStyle = createGlobalStyle`
  ${`.${tyPopoverDropdownCls}`}.ant-select-dropdown{
    padding: 12px !important;
    border-radius: 20px !important;
    background-color: var(--Fill_Background_Light) !important;
    box-sizing: border-box;
    border: 1px solid var(--Line_Brand_Secondary);
    box-shadow: 0px 8px 32px 0px rgba(0, 0, 0, 0.04) !important;

    .ant-select-item {
      &.ant-select-item-option-selected:not(.ant-select-item-option-disabled) {
        background-color: var(--Fill_Background) !important;
        font-weight: 500;
        color: var(--Text_Primary);
      }
      &.ant-select-item-option  {
      padding: 8px 12px;
      border-radius: 12px;
      background-color: var(--Fill_Background_Light) !important;

      &:hover {
        background-color: var(--Fill_Background) !important;
      }

      .ant-select-item-option-content {
        font-family: PingFang SC;
        font-size: 13px;
        font-weight: 500;
        line-height: 20px;
        letter-spacing: 0.2px;
        color: var(--Text_Primary);
        text-align: center;
      }

      .anticon-check {
         color: var(--Text_Primary);
      }
    }
    }
  }
`;
