import { Select as AntdSelect, SelectProps } from "antd";
import classNames from "classnames";
import { tyPopoverCls, tyPopoverDropdownCls } from "./styled";
import React from "react";

export const Select = (props: SelectProps) => {
  return (
    <AntdSelect
      {...props}
      // getPopupContainer={(triggerNode) =>
      //   document.getElementById('anything-root') ||
      //     document.getElementById('root') ||
      //     (triggerNode.parentNode as any)
      //   }
      className={classNames(tyPopoverCls, props.className)}
      popupClassName={classNames(tyPopoverDropdownCls, props.popupClassName)}
    />
  );
};

Object.assign(Select, AntdSelect);
