import { createGlobalStyle } from "styled-components";

export const tyInputCls = "ty-input";
export const tyTransparentBgInputCls = "ty-input-transparent-bg";

export const InputInjectStyle = createGlobalStyle`body, html {
  ${`.${tyInputCls}`} {
    &.ant-input-affix-wrapper .ant-input,
    &.ant-input {
      color: var(--Text_Primary);
      box-shadow: none;
      border-radius: 8px;
      caret-color: var(--Line_Primary);
    }
    &.ant-input-affix-wrapper .ant-input::placeholder,
    &.ant-input::placeholder {
      color: var(--Text_Disabled);
    }
    &.ant-input-outlined {
      border-color: var(--Line_Primary);
      background-color: rgb(var(--Fill_Tertiary));
      &:hover {
        border-color: var(--Line_Primary);
      }
      &:focus, &:focus-within {
        border-color: var(--Line_Primary);
      }
    }

    &.${tyTransparentBgInputCls} {
      border-color: transparent;
      background-color: transparent;
    }
    
    &.ant-input-filled {
      background-color: var(--Fill_Tertiary);
      border: none !important;
      display: flex;
      align-items: flex-start;
      &:hover, &:focus, &:focus-within {
        border: none !important;
        background-color: var(--Fill_Tertiary);
      }
    }

    &.ant-input-outlined.ant-input-disabled {
      background-color: var(--Fill_Background);
    }

    &.ant-input-outlined.ant-input-status-error:not(.ant-input-disabled) {
      border-color: var(--Danger_Default);

    }
    &.ant-input-outlined.ant-input-status-warning:not(.ant-input-disabled) {
      border-color: var(--Warning_Clicked);

    }

    &.ant-input-outlined:focus,
    &.ant-input-outlined:hover,
    &.ant-input-outlined:focus-within {
      background-color: rgb(var(--Fill_Tertiary));
      border-color: var(--Line_Primary);
      box-shadow: none;
    }
    .ant-input-clear-icon, .ant-input-clear-icon:hover {
      font-size: 14px;
      color: var(--Text_Disabled);
    }
    .ant-input-suffix .ant-input-show-count-suffix {
      color: var(--Text_Primary);;
    }
  }}
`;
