import { createGlobalStyle } from "styled-components";

export const tyDropdownCls = "ty-dropdown";

export const DropdownInjectStyle = createGlobalStyle`body, html{
  ${`.${tyDropdownCls}`} {
    &.ant-dropdown .ant-dropdown-menu,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu {
      border-radius: 20px;
      background: var(--Fill_Background_Light);
      box-sizing: border-box;
      border: 1px solid var(--Line_Brand_Secondary);
      padding: 12px;
    }

    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item.ant-dropdown-menu-item-danger:not(.ant-dropdown-menu-item-disabled),
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-item.ant-dropdown-menu-item-danger:not(.ant-dropdown-menu-item-disabled) {
      color: var(--Text_Danger);
    }

    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item.ant-dropdown-menu-item-danger:not(.ant-dropdown-menu-item-disabled):hover,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-item.ant-dropdown-menu-item-danger:not(.ant-dropdown-menu-item-disabled):hover {
      background-color: var(--Danger_Background);
      color: var(--Text_Danger);
    }

    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-item,
    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-submenu-title,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-submenu-title {
      padding: 6px 12px;
      border-radius: 4px;
      color: var(--Text_Primary);
      font-size: 14px;
    }

    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item:hover,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-item:hover,
    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-submenu-title:hover,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-submenu-title:hover,
    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item-active,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-item-active,
    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-submenu-title-active,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-submenu-title-active {
      background-color: var(--Fill_Background);
      border-radius: 12px;
    }

    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item-divider,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-item-divider,
    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-submenu-title-divider,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-submenu-title-divider {
      background-color: var(--Line_Secondary);
      margin-left: -4px;
      margin-right: -4px;
    }

    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item-icon,
    &.ant-dropdown-menu-submenu .ant-dropdown-menu .ant-dropdown-menu-item-icon {
      font-size: 20px;
    }
    &.ant-dropdown .ant-dropdown-menu:focus {
      outline: none;
    }
    &.ant-dropdown .ant-dropdown-menu:focus-visible {
      outline: none;
    }
    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item:focus {
      outline: none;
    }
    &.ant-dropdown .ant-dropdown-menu .ant-dropdown-menu-item:focus-visible {
      outline: none;
    }
  }}
`;
