import { createGlobalStyle } from "styled-components";

export const tyCheckboxCls = "ty-checkbox";
export const tyCheckboxGroupCls = "ty-checkbox-group";

export const CheckboxInjectStyle = createGlobalStyle`body, html {
  ${`.${tyCheckboxCls}`}, ${`.${tyCheckboxGroupCls}`} .ant-checkbox-wrapper {
    &.ant-checkbox-wrapper {
      font-size: 12px;
      color: var(--Text_Primary);
    }

    .ant-checkbox-input:focus-visible,
    .ant-checkbox .ant-checkbox-input:focus-visible+.ant-checkbox-inner {
      outline: none;
    }

    .ant-checkbox .ant-checkbox-inner {
      border-color: var(--Line_Primary);
      background-color: var(--Fill_Background_Light);

      &::after {
        border-color: var(--Fill_Background_Light);
      }
    }

    &.ant-checkbox-wrapper:not(.ant-checkbox-wrapper-disabled):hover .ant-checkbox-inner,
    .ant-checkbox:not(.ant-checkbox-disabled):hover .ant-checkbox-inner {
      border-color: var(--Line_Heavy);
    }

    .ant-checkbox-checked .ant-checkbox-inner {
      border-color: var(--Fill_Brand_Inverse);
      background-color: var(--Fill_Brand_Inverse);
    }

    .ant-checkbox-disabled .ant-checkbox-inner {
      background: var(--Fill_Brand_Tertiary);
      border-color: var(--Line_Light);
    }

    &.ant-checkbox-wrapper:not(.ant-checkbox-wrapper-disabled):hover .ant-checkbox-checked:not(.ant-checkbox-disabled) .ant-checkbox-inner {
      border-color:var(--Fill_Brand_Primary);
    }

    .ant-checkbox .ant-checkbox-inner {
      width: 12px;
      height: 12px;
      border-radius: 2px;
    }

    .ant-checkbox-checked .ant-checkbox-inner:after {
      border-width: 1px;
      width: 3.6px;
      height: 5.7px;
      top: 46%;
      inset-inline-start: 28%;
      transition: none;
    }

    .ant-checkbox + span {
      padding-inline-start: 11px;
    }

    .ant-checkbox-indeterminate .ant-checkbox-inner:after {
      top: 50%;
      inset-inline-start: 50%;
      width: 6px;
      height: 6px;
      background-color: var(--Fill_Brand_Primary);
    }

    .ant-checkbox-indeterminate .ant-checkbox-inner {
      border-color: var(--Line_Primary);
      background-color: var(--Fill_Background_Light);
    }
  }}
`;
