import { createGlobalStyleOnce } from "@tingwujs/common";
import { createGlobalStyle, css } from "styled-components";
import { TYColorVars } from "../../colors";
import { AntdOverrideStyle } from "../antdOverride/antdOverrideCss";
import React from "react";

export const TYScrollBar = css`
  ::-webkit-scrollbar {
    width: 3px;
    height: 6px;
    transition: all 0.25s;
  }

  ::-webkit-scrollbar-thumb:horizontal:hover,
  ::-webkit-scrollbar-thumb:vertical:hover {
    background: var(--Line_Light);
  }

  ::-webkit-scrollbar-track {
    border-radius: 0;
    background-color: transparent;
  }
  ::-webkit-scrollbar-thumb {
    background: #eaecef; /* 滚动条的颜色 */
    border-radius: 4px; /* 滚动条的圆角 */
  }

  ::-webkit-scrollbar-thumb:hover {
    background: #eaecef; /* 滚动条悬停时的颜色 */
  }

  html.dark {
    ::-webkit-scrollbar-thumb {
      background: #2b2b2b; /* 滚动条的颜色 */
    }
    ::-webkit-scrollbar-thumb:hover {
      background: #2b2b2b; /* 滚动条悬停时的颜色 */
    }
  }
`;

const TYScrollBarNew = TYScrollBar;
const InternalTyCss = createGlobalStyle`
  ${TYScrollBarNew}
`;
export const TYTokenColorVars = createGlobalStyle`
  ${TYColorVars}
`;

export const TyCss = () => {
  return (
    <>
      <InternalTyCss />
      <AntdOverrideStyle />
    </>
  );
};

export const TyCssOnce = createGlobalStyleOnce(() => <TyCss />);
