import Icon, { createFromIconfontCN } from "@ant-design/icons";
import React from "react";

import { IconBaseProps } from "@ant-design/icons/lib/components/Icon.js";

export interface IconFontProps<T extends string = string> extends IconBaseProps {
  type: T;
}
export const TYIconPlugin = (props: any) => {
  const Iconfont = React.forwardRef<HTMLSpanElement, IconFontProps>((iconProps, ref) => {
    const { type, children, ...restProps } = iconProps;
    // children > type
    let content: React.ReactNode = null;
    if (iconProps.type) {
      content = <use xlinkHref={`#${type}`} />;
    }
    if (children) {
      content = children;
    }
    return (
      <Icon {...restProps} ref={ref}>
        {content}
      </Icon>
    );
  });
  Iconfont.displayName = "Iconfont";
  return <Iconfont {...props} />;
};

export function generateIconByScriptUrl(url: string) {
  return createFromIconfontCN({
    scriptUrl: url,
  });
}
