import React, { memo, useMemo } from "react";
import { Description, FullScreen, Image, Title, Wrapper } from "./styled";
import { Button } from "../antdOverride";

export type ExceptionType =
  | "error"
  | "noData"
  | "noNetwork"
  | "accessFrozen"
  | "noPermission"
  | "dataLoss";

const iconUrlMap: Record<ExceptionType, string> = {
  error:
    "https://img.alicdn.com/imgextra/i3/O1CN01dakLB11KzDoI9gGLP_!!6000000001234-55-tps-63-47.svg",
  noData:
    "https://img.alicdn.com/imgextra/i1/O1CN01ZtrCgj1aUZ9U5idqu_!!6000000003333-55-tps-64-56.svg",
  noNetwork:
    "https://img.alicdn.com/imgextra/i4/O1CN01XPHfDc1lFsDjjM2Rs_!!6000000004790-55-tps-60-60.svg",
  accessFrozen:
    "https://img.alicdn.com/imgextra/i3/O1CN01GAoG6a26RsX5oiS87_!!6000000007659-55-tps-59-57.svg",
  noPermission:
    "https://img.alicdn.com/imgextra/i3/O1CN01dakLB11KzDoI9gGLP_!!6000000001234-55-tps-63-47.svg",
  dataLoss:
    "https://img.alicdn.com/imgextra/i1/O1CN014gg6l21QSbIM8UsNZ_!!6000000001975-55-tps-58-46.svg",
};

export interface ExceptionProps {
  fullScreen?: boolean;
  type: ExceptionType;
  iconUrl?: string;
  title: string;
  description?: string;
  showBtn?: boolean;
  btnTitle?: string;
  onClickBtn?: (event: React.MouseEvent) => void;
  style?: React.CSSProperties;
}

export const Exception = memo((props: ExceptionProps) => {
  const {
    fullScreen = false,
    type,
    title,
    iconUrl,
    description,
    showBtn = true,
    btnTitle = "返回上一级",
    onClickBtn,
    style,
  } = props;

  const realIconUrl = iconUrl || iconUrlMap[type] || iconUrlMap.error;
  // console.log('debug realIconUrl', realIconUrl);

  const element = useMemo(() => {
    return (
      <Wrapper style={style}>
        <Image style={{ backgroundImage: `url(${realIconUrl})` }} />
        <Title>{title}</Title>
        {description && <Description>{description}</Description>}
        {showBtn && (
          <Button type="primary" style={{ marginTop: 16 }} onClick={onClickBtn}>
            {btnTitle}
          </Button>
        )}
      </Wrapper>
    );
  }, [title, description, onClickBtn, showBtn, btnTitle, realIconUrl, style]);

  if (fullScreen) {
    return <FullScreen>{element}</FullScreen>;
  }
  return element;
});
