import { css } from "styled-components";
// import { tyDarkColors } from './tyDarkColors';
// import { tyLightColors } from './tyLightColors';
import { bailianLightColors } from "./bailianLightColors";
import { tyLightColors } from "./tyLightColors";

type Tokens = keyof typeof bailianLightColors;

export function getTYColor(token: Tokens) {
  return bailianLightColors[token];
}

// function renderCss(colorMap: Record<string, string>) {
//   return Object.entries(colorMap).map(([key, value]) => {
//     return `--TY-${key}: ${value};`;
//   }).join('\n');
// }

const fontFamilyObj = {
  "--font-family":
    "system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell, Noto Sans, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol, Noto Color Emoji, BlinkMacSystemFont, Helvetica Neue, Arial, PingFang SC, PingFang TC, PingFang HK, Microsoft Yahei, Microsoft JhengHei;",
};

export const TYColorVars = css`
  #root,
  #root.global-light-theme,
  .appRoot {
    ${tyLightColors}
  }

  #root.global-dark-theme,
  .appRoot {
    ${tyLightColors}
  }
  #root.global-dark-theme,
  .appRoot {
    ${tyLightColors}
  }
`;
