const getBaiLianVarColor = (token: string) => {
  return `var(--tingwu-${token})`;
};

export const bailianLightColors = {
  "--Fill_Background_Light": getBaiLianVarColor("color-bg-base"),
  "--Fill_Background": getBaiLianVarColor("color-bg-layout"),
  "--Fill_Brand_Primary": getBaiLianVarColor("color-primary"),

  "--Text_White": getBaiLianVarColor("color-text-white"), // G0
  "--Text_Primary": getBaiLianVarColor("color-text"), // G90
  "--Text_Secondary": getBaiLianVarColor("color-text-secondary"), // G70
  "--Text_Caption": getBaiLianVarColor("color-text-tertiary"), // G50
  "--Text_Disabled": getBaiLianVarColor("color-text-quaternary"), // G30
  "--Text_Danger": getBaiLianVarColor("color-text-error"),
  "--Text_Brand_Primary": getBaiLianVarColor("color-primary"),
  "--Text_Brand_Light": getBaiLianVarColor("color-text-secondary"),
  "--Text_Black": getBaiLianVarColor("color-text"),

  "--Fill_Tertiary": getBaiLianVarColor("color-fill-tertiary"),
  "--Fill_Secondary": getBaiLianVarColor("color-fill-secondary"),
  "--Fill_Primary": getBaiLianVarColor("color-fill"),
  "--Fill_Disabled": getBaiLianVarColor("color-fill-disable"),
  "--Fill_Heavy": getBaiLianVarColor("color-fill"),
  "--Fill_White": getBaiLianVarColor("color-bg-container"),
  "--Fill_Black": getBaiLianVarColor("color-text-base"),
  "--Fill_Brand_Light": getBaiLianVarColor("color-bg-container"),
  "--Fill_Brand_Background": getBaiLianVarColor("color-primary-bg"),
  "--Fill_Brand_Tertiary": getBaiLianVarColor("color-primary-bg-hover"),
  "--Fill_Brand_Secondary": getBaiLianVarColor("color-primary-text-hover"),
  "--Fill_Brand_Inverse": getBaiLianVarColor("color-primary"),
  "--Fill_Transparent_Primary": getBaiLianVarColor("color-text-base"),
  "--Fill_Transparent_Light": getBaiLianVarColor("color-fill-tertiary"),

  "--Line_Light": getBaiLianVarColor("color-border-secondary"),
  "--Line_Secondary": getBaiLianVarColor("color-border-secondary"),
  "--Line_Primary": getBaiLianVarColor("color-border-secondary"),
  "--Line_Heavy": getBaiLianVarColor("color-border"),
  "--Line_Brand_Light": getBaiLianVarColor("color-primary-border"),
  "--Line_Brand_Secondary": getBaiLianVarColor("color-primary-border"),
  "--Line_Brand_Primary": getBaiLianVarColor("color-primary"),

  "--Danger": getBaiLianVarColor("color-error"),
  "--Danger_Background": getBaiLianVarColor("color-error-bg"),
  "--Danger_Disabled": getBaiLianVarColor("color-error-hover"),
  "--Danger_Default": getBaiLianVarColor("color-error"),
  "--Danger_Clicked": getBaiLianVarColor("color-error"),

  "--Success": getBaiLianVarColor("color-success"),
  "--Success_Background": getBaiLianVarColor("color-success-bg"),
  "--Success_Disabled": getBaiLianVarColor("color-success-hover"),
  "--Success_Default": getBaiLianVarColor("color-success"),
  "--Success_Clicked": getBaiLianVarColor("color-success"),

  "--Caution": getBaiLianVarColor("color-warning"),
  "--Caution_Background": getBaiLianVarColor("color-warning-bg"),
  "--Caution_Disabled": getBaiLianVarColor("color-warning-hover"),
  "--Caution_Default": getBaiLianVarColor("color-warning"),
  "--Caution_Clicked": getBaiLianVarColor("color-warning"),

  "--Warning": getBaiLianVarColor("color-warning"),
  "--Warning_Background": getBaiLianVarColor("color-warning-bg"),
  "--Warning_Disabled": getBaiLianVarColor("color-warning-hover"),
  "--Warning_Default": getBaiLianVarColor("color-warning"),
  "--Warning_Clicked": getBaiLianVarColor("color-warning"),

  "--Processing": getBaiLianVarColor("color-info"),
  "--Processing_Background": getBaiLianVarColor("color-info-bg"),
  "--Processing_Disabled": getBaiLianVarColor("color-info-hover"),
  "--Processing_Default": getBaiLianVarColor("color-info"),
  "--Processing_Clicked": getBaiLianVarColor("color-info"),

  "--Link": getBaiLianVarColor("color-link"),
  "--Link_Background": getBaiLianVarColor("color-purple-bg"),
  "--Link_Disabled": getBaiLianVarColor("color-purple-hover"),
  "--Link_Default": getBaiLianVarColor("color-color-link"),
  "--Link_Clicked": getBaiLianVarColor("color-color-link"),

  "--Pending": getBaiLianVarColor("color-mauve"),
  "--Pending_Background": getBaiLianVarColor("color-mauve-bg"),
  "--Pending_Disabled": getBaiLianVarColor("color-mauve-hover"),
  "--Pending_Default": getBaiLianVarColor("color-mauve"),
  "--Pending_Clicked": getBaiLianVarColor("color-mauve"),

  "--Gradient_Primary": "radial-gradient(120% 132% at 77% 11%, #D75EFF 9%, #0055FF 100%)",
  "--Gradient_Light": "linear-gradient(243deg,#615ced 0%,#8884f6 100%)",
  "--Gradient_Heavy": "linear-gradient(63deg,#7b38f4 0%,#615ced 100%)",
  "--Gradient_Radial":
    "conic-gradient(from 135deg at -18% -40%,#615ced -26deg,#7b38f4 53deg,#e193ff 169deg,#7423de 254deg,#615ced 334deg,#7b38f4 413deg )",

  "--Decoration_Pink": getBaiLianVarColor("color-pink"),
  "--Decoration_Orange": getBaiLianVarColor("color-orange"),
  "--Decoration_Green": getBaiLianVarColor("color-green"),
  "--Decoration_Blue": getBaiLianVarColor("color-blue"),
  "--Decoration_Purple": getBaiLianVarColor("color-purple"),
  "--Decoration_Dark_Purple": "#7423de",
  "--Decoration_Pink_Purple": "#c564ea",

  "--Mask_Laptop": getBaiLianVarColor("color-bg-mask"),
  "--Mask_Primary": getBaiLianVarColor("color-bg-mask"),
  "--Mask_Secondary": getBaiLianVarColor("color-bg-mask"),

  "--skeleton-bg": getBaiLianVarColor("color-fill-tertiary"),
  "--Puppet_Input_Box_Shadow": getBaiLianVarColor("box-shadow-input"),
};
