# @tingwujs/design

听悟项目设计系统，提供统一的 UI 组件和设计规范。

## 📦 安装

```bash
npm install @tingwujs/design
```

## 🎯 功能特性

- **颜色系统**: 统一的颜色规范和工具
- **UI 组件**: 基于 Ant Design 的定制组件
- **设计工具**: 设计相关的工具函数

## 📖 使用示例

```typescript
import { 
  TYProvider,
  TYIcon 
} from '@tingwujs/design';
import { message } from 'antd';

// 使用主题提供者
<TYProvider>
  <YourApp />
</TYProvider>

// 使用图标
<TYIcon type="icon-name" size={24} />

// 使用消息提示（从 antd 导入，但由 design 包统一管理）
message.success('操作成功');
```

## 🔧 开发

```bash
# 安装依赖
npm install

# 构建
npm run build

# 类型检查
npm run typechecking

# 代码检查
npm run lint

# 运行测试
npm run test
```

## 📄 许可证

[GPL-3.0-or-later](../../LICENSE)

