import { OldSelection } from "../controller/type";

export const findSelections = (
  textContent: string,
  keyword: string,
  extraParams: Pick<OldSelection, "pid" | "readonly">
) => {
  let offset = 0;
  const keywordLength = keyword.length;
  const foundTexts: OldSelection[] = [];
  while (true) {
    const pos = textContent.indexOf(keyword, offset);
    if (pos > -1) {
      const startOffset = pos;
      const endOffset = pos + keywordLength;
      foundTexts.push({
        startOffset,
        endOffset,
        pid: extraParams.pid,
        ...(extraParams.readonly !== undefined ? { readonly: extraParams.readonly } : {}),
      });
      offset = pos + keywordLength;
    } else {
      break;
    }
  }
  return foundTexts;
};
