export interface ISc {
  bt: number;
  et: number;
  id: number;
  si: number;
  tc: string;
  pt?: number;
  tag?: {
    mark?: string;
  };
}

export interface P {
  pi: string;
  ui?: string;
  fixText?: ISc[];
  sc: ISc[];
}

export type SC = P["sc"][0];

export interface TranModel {
  pg: P[];
}

export type PID = string;
export type EmptyUnfixPID = "emptyUnfixPid";
export type WID = string;
export type UID = string;
export type SID = string;

export interface Word {
  wid: WID;
  sentenceId: SID;
  beginTime: number;
  endTime: number;
  text: string;
  tag: string;
  nFix?: boolean;
}

export interface Sentence {
  sid: SID;
  wids: WID[];
}

export interface Paragraph {
  pid: PID;
  uid?: UID;
  wids: WID[];
  isUnfix?: boolean; // unfix段落
}

export interface Transcription {
  paragraphs: Record<PID, Paragraph>;
  pids: PID[];
  words: Record<WID, Word>;
  appearedWids: Record<WID, boolean>;
  userChangedSidsMap: Record<SID, boolean>;
}

export interface TranslateLanguage {
  translateSourceLanguage?: number; // 翻译源语言:  1 | 2 | 3 | 4 | 5; 1中文 2英语 3粤语 4中英文自由说 5日语
  translateTargetLanguage?: number; // 翻译语言: 0 | 1 | 2 | 5; 0不翻译 1中文 2英语 5日语
}
