import { PID } from "../persist";
import { AbstractCmdController } from "./abstractCmdController";

export class UnfixToFixedController extends AbstractCmdController {
  private unfixToFixedPid: PID | undefined;

  private unfixToFixedKeepFocusPid: PID | undefined;

  private lastUnfixPid: PID | undefined;

  private lastUnfixIsFocus = false;

  private firstUnfixPid: PID | undefined;

  setLastUnfixPid(lastUnfixPid: PID) {
    if (!this.firstUnfixPid) {
      this.firstUnfixPid = lastUnfixPid;
    }
    if (this.lastUnfixPid) {
      if (this.lastUnfixIsFocus) {
        this.unfixToFixedKeepFocusPid = this.lastUnfixPid;
      }
      this.unfixToFixedPid = this.lastUnfixPid;
    }
    this.lastUnfixPid = lastUnfixPid;
    this.lastUnfixIsFocus = false;
  }

  getLastUnfixPid() {
    return this.lastUnfixPid;
  }

  getUnfixToFixedPid() {
    return this.unfixToFixedPid;
  }

  setLastUnfixIsFocus(isFocus: boolean) {
    this.lastUnfixIsFocus = isFocus;
  }

  clearFocus() {
    this.lastUnfixIsFocus = false;
    this.unfixToFixedKeepFocusPid = undefined;
  }

  getUnfixToFixedKeepFocusPid() {
    return this.unfixToFixedKeepFocusPid;
  }

  getFirstUnfixPid() {
    return this.firstUnfixPid;
  }

  isFirstUnfixPid(pid: PID | undefined) {
    const unfixPid = this.controller.getUnfixPid();
    if (unfixPid && unfixPid !== this.firstUnfixPid) {
      return false;
    }

    return this.firstUnfixPid === pid;
  }

  reset() {
    this.unfixToFixedPid = undefined;
    this.lastUnfixPid = undefined;
    this.firstUnfixPid = undefined;
    this.unfixToFixedKeepFocusPid = undefined;
    this.lastUnfixIsFocus = false;
  }
}
