import { AbstractCmdController } from "./abstractCmdController";

export class TextBoxController extends AbstractCmdController {
  _caretPending = false;

  timeout: ReturnType<typeof setTimeout> | null = null;

  handleTextboxInput() {
    this.caretPending = true;
    if (this.timeout) {
      clearTimeout(this.timeout);
    }
    this.timeout = setTimeout(() => {
      this.caretPending = false;
      this.timeout = null;
    }, 1000);
  }

  set caretPending(caretPending: boolean) {
    this._caretPending = caretPending;
    this.controller.emit("caretPendingChange", { caretPending });
  }

  get caretPending() {
    return this._caretPending;
  }

  focusEditor() {
    this.controller.emit("focusEditor", {});
  }
}
