import { Controller } from "../index";
import { getNfixingAndFixedWids } from "../../utils/text";
import {
  normalNFixFrame,
  changeNFixFrame,
  changeNFixFrame2,
  changeNFixFrame3,
} from "./mock/nfixChangeParagraph.data";

describe("nfixChangeParagraph", () => {
  it("change：增量式追加nfix", async () => {
    const controller = new Controller();
    controller.setLivingMode(true);
    controller.injectSpeakersGetter(() => []);
    controller.injectSpeakersSetter(() => {});
    controller.on("paragraphChangeSpecific", event => {
      event.addParagraphPids.forEach(() => {
        // console.log('------- event', controller.getParagraph(pid));
      });
    });

    controller.processParagraphFrames(normalNFixFrame);

    // expect：unfix的 lastPid下标，应该为 normalNFixFrame 的 尾部pid
    expect(controller.getUnfixPid()).toEqual(`${normalNFixFrame[normalNFixFrame.length - 1].pi}`);

    // 触发追加
    controller.processParagraphFrames(changeNFixFrame);

    // expect：根据数据测试，unfix的 lastPid下标，应该为 paragraphForceBreakFrame 的 尾部pid
    expect(controller.getUnfixPid()).toEqual("1");

    // expect：根据数据测试，sc 50，在 pi：1
    expect(controller.getPidByWid("50")).toEqual("1");
    // expect：根据数据测试，追加的 sc 70，在 pi：1
    expect(controller.getPidByWid("70")).toEqual("1");

    // expect：根据数据测试，验证word归属sc正确
    expect(controller.getLatestSid()).toEqual("2");
    expect(controller.getFirstWordBySid("2")?.wid).toEqual("50");
    expect(controller.getWord("40").sentenceId).toEqual("1");
    expect(controller.getWord("50").sentenceId).toEqual("2");
    expect(controller.getWord("60").sentenceId).toEqual("2");
    expect(controller.getWord("70").sentenceId).toEqual("2");

    const allWids: any[] = [];
    const nFixWids: any[] = [];
    const fixedWids: any[] = [];
    normalNFixFrame.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          // sdk数据模型，id相关，都变为字符串
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });
    changeNFixFrame.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });

    // expect：对应段落数据，没有丢词
    const pg = controller.getParagraph("1");
    expect(pg.wids).toMatchObject(nFixWids);
    // expect：验证 段落数据，按预期分段
    expect(pg.isUnfix).toEqual(true);

    const wordsMap = getNfixingAndFixedWids(controller, allWids);
    // expect：验证 工具方法，n字fix的标没问题
    expect(wordsMap.nfixingWids).toMatchObject(nFixWids);
    // expect：根据数据测试，验证 工具方法，n字fix的标没问题
    expect(wordsMap.nfixingWids).toMatchObject(["10", "20", "30", "40", "50", "60", "70"]);
    // expect：验证 工具方法，非n字fix的标没问题
    expect(wordsMap.fixedWids).toMatchObject([]);

    await new Promise(r => setTimeout(r, 2000));
  });
  it("change：追加nfix 2，增量式连续追加", async () => {
    const controller = new Controller();
    controller.setLivingMode(true);
    controller.injectSpeakersGetter(() => []);
    controller.injectSpeakersSetter(() => {});
    controller.on("paragraphChangeSpecific", event => {
      event.addParagraphPids.forEach(() => {
        // console.log('------- event', controller.getParagraph(pid));
      });
    });

    controller.processParagraphFrames(normalNFixFrame);

    // expect：unfix的 lastPid下标，应该为 normalNFixFrame 的 尾部pid
    expect(controller.getUnfixPid()).toEqual(`${normalNFixFrame[normalNFixFrame.length - 1].pi}`);

    // 触发追加
    controller.processParagraphFrames(changeNFixFrame);
    // 触发追加
    controller.processParagraphFrames(changeNFixFrame2);

    // expect：根据数据测试，unfix的 lastPid下标，应该为 paragraphForceBreakFrame 的 尾部pid
    expect(controller.getUnfixPid()).toEqual("1");

    // expect：根据数据测试，sc 50，在 pi：1
    expect(controller.getPidByWid("50")).toEqual("1");
    // expect：根据数据测试，追加的 sc 70，在 pi：1
    expect(controller.getPidByWid("70")).toEqual("1");
    // expect：根据数据测试，追加的 sc 70，在 pi：1
    expect(controller.getPidByWid("80")).toEqual("1");

    // expect：根据数据测试，验证word归属sc正确
    expect(controller.getLatestSid()).toEqual("2");
    expect(controller.getFirstWordBySid("2")?.wid).toEqual("50");
    expect(controller.getWord("40").sentenceId).toEqual("1");
    expect(controller.getWord("50").sentenceId).toEqual("2");
    expect(controller.getWord("60").sentenceId).toEqual("2");
    expect(controller.getWord("70").sentenceId).toEqual("2");
    expect(controller.getWord("80").sentenceId).toEqual("2");

    const allWids: any[] = [];
    const nFixWids: any[] = [];
    const fixedWids: any[] = [];
    normalNFixFrame.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          // sdk数据模型，id相关，都变为字符串
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });
    changeNFixFrame.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });
    changeNFixFrame2.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });

    // expect：对应段落数据，没有丢词
    const pg = controller.getParagraph("1");
    expect(pg.wids).toMatchObject(nFixWids);
    // expect：验证 段落数据，按预期分段
    expect(pg.isUnfix).toEqual(true);

    const wordsMap = getNfixingAndFixedWids(controller, allWids);
    // expect：验证 工具方法，n字fix的标没问题
    expect(wordsMap.nfixingWids).toMatchObject(nFixWids);
    // expect：根据数据测试，验证 工具方法，n字fix的标没问题
    expect(wordsMap.nfixingWids).toMatchObject(["10", "20", "30", "40", "50", "60", "70", "80"]);
    // expect：验证 工具方法，非n字fix的标没问题
    expect(wordsMap.fixedWids).toMatchObject([]);

    await new Promise(r => setTimeout(r, 2000));
  });

  it("change：追加nfix 3，增量式连续追加，换句子", async () => {
    const controller = new Controller();
    controller.setLivingMode(true);
    controller.injectSpeakersGetter(() => []);
    controller.injectSpeakersSetter(() => {});
    controller.on("paragraphChangeSpecific", event => {
      event.addParagraphPids.forEach(() => {
        // console.log('------- event', controller.getParagraph(pid));
      });
    });

    controller.processParagraphFrames(normalNFixFrame);

    // expect：unfix的 lastPid下标，应该为 normalNFixFrame 的 尾部pid
    expect(controller.getUnfixPid()).toEqual(`${normalNFixFrame[normalNFixFrame.length - 1].pi}`);

    // 触发追加
    controller.processParagraphFrames(changeNFixFrame);
    // 触发追加
    controller.processParagraphFrames(changeNFixFrame2);
    // 触发追加
    controller.processParagraphFrames(changeNFixFrame3);

    // expect：根据数据测试，unfix的 lastPid下标，应该为 paragraphForceBreakFrame 的 尾部pid
    expect(controller.getUnfixPid()).toEqual("1");

    // expect：根据数据测试，sc 50，在 pi：1
    expect(controller.getPidByWid("50")).toEqual("1");
    // expect：根据数据测试，追加的 sc 70，在 pi：1
    expect(controller.getPidByWid("70")).toEqual("1");
    // expect：根据数据测试，追加的 sc 80，在 pi：1
    expect(controller.getPidByWid("80")).toEqual("1");
    // expect：根据数据测试，追加的 sc 90，在 pi：1
    expect(controller.getPidByWid("90")).toEqual("1");

    // expect：根据数据测试，验证word归属sc正确
    expect(controller.getLatestSid()).toEqual("3");
    expect(controller.getFirstWordBySid("3")?.wid).toEqual("90");
    expect(controller.getWord("40").sentenceId).toEqual("1");
    expect(controller.getWord("50").sentenceId).toEqual("2");
    expect(controller.getWord("60").sentenceId).toEqual("2");
    expect(controller.getWord("70").sentenceId).toEqual("2");
    expect(controller.getWord("80").sentenceId).toEqual("2");
    expect(controller.getWord("90").sentenceId).toEqual("3");

    const allWids: any[] = [];
    const nFixWids: any[] = [];
    const fixedWids: any[] = [];
    normalNFixFrame.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          // sdk数据模型，id相关，都变为字符串
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });
    changeNFixFrame.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });
    changeNFixFrame2.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });
    changeNFixFrame3.forEach(({ sc }) => {
      sc.forEach(({ pt, id }) => {
        if (pt) {
          nFixWids.push(`${id}`);
        } else {
          fixedWids.push(`${id}`);
        }
        allWids.push(`${id}`);
      });
    });

    // expect：对应段落数据，没有丢词
    const pg = controller.getParagraph("1");
    expect(pg.wids).toMatchObject(nFixWids);
    // expect：验证 段落数据，按预期分段
    expect(pg.isUnfix).toEqual(true);

    const wordsMap = getNfixingAndFixedWids(controller, allWids);
    // expect：验证 工具方法，n字fix的标没问题
    expect(wordsMap.nfixingWids).toMatchObject(nFixWids);
    // expect：根据数据测试，验证 工具方法，n字fix的标没问题
    expect(wordsMap.nfixingWids).toMatchObject([
      "10",
      "20",
      "30",
      "40",
      "50",
      "60",
      "70",
      "80",
      "90",
    ]);
    // expect：验证 工具方法，非n字fix的标没问题
    expect(wordsMap.fixedWids).toMatchObject([]);

    await new Promise(r => setTimeout(r, 2000));
  });
});
