import { P } from "../../../persist";

interface Frame extends P {
  partial: boolean;
}

type Frames = Frame[];

export const normalNFixFrame: Frames = [
  {
    partial: true,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
        pt: 1,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
        pt: 1,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
        pt: 1,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
        pt: 1,
      },
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
        pt: 1,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
        pt: 1,
      },
    ],
  },
];

// 正常成段1
export const paragraphNormalBreakFrame: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 1,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 1,
        tc: "总是遗漏",
        id: 60,
      },
    ],
  },
];

// 正常成段2：成段时，多了词
export const paragraphNormalBreakFrame2: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 1,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 1,
        tc: "总是遗漏",
        id: 60,
      },
      {
        bt: 6000,
        et: 7000,
        si: 1,
        tc: "不少",
        id: 70,
      },
    ],
  },
];

// 正常成段3：成段时，部分word的sc变化
export const paragraphNormalBreakFrame3: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
      },
    ],
  },
];

// 正常成段4：成段时，部分word的sc变化，同时新增词
export const paragraphNormalBreakFrame4: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
      },
      {
        bt: 6000,
        et: 7000,
        si: 2,
        tc: "不少",
        id: 70,
      },
    ],
  },
];

// 正常成段5：成段同时，多了 新段落
export const paragraphNormalBreakFrame5: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 1,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 1,
        tc: "总是遗漏",
        id: 60,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 6000,
        et: 7000,
        si: 2,
        tc: "不少",
        id: 70,
        pt: 1,
      },
    ],
  },
];

// 正常成段6：成段同时，多了 新段落，老段落，也多了新词
export const paragraphNormalBreakFrame6: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 1,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 1,
        tc: "总是遗漏",
        id: 60,
      },
      {
        bt: 6000,
        et: 7000,
        si: 1,
        tc: "不少",
        id: 70,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 7000,
        et: 8000,
        si: 2,
        tc: "我们看到新段落",
        id: 80,
        pt: 1,
      },
    ],
  },
];

// 正常成段7：成段同时，多了 新段落，老段落，也多了新词，且sc也是新的
export const paragraphNormalBreakFrame7: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 1,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 1,
        tc: "总是遗漏",
        id: 60,
      },
      {
        bt: 6000,
        et: 7000,
        si: 2,
        tc: "不少",
        id: 70,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 7000,
        et: 8000,
        si: 3,
        tc: "我们看到新段落",
        id: 80,
        pt: 1,
      },
    ],
  },
];

// 正常成段8：成段同时，多了 新段落，老段落，也多了新词，且sc也是新的，部分老词sc也有更新
export const paragraphNormalBreakFrame8: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
      },
      {
        bt: 6000,
        et: 7000,
        si: 2,
        tc: "不少",
        id: 70,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 7000,
        et: 8000,
        si: 3,
        tc: "我们看到新段落",
        id: 80,
        pt: 1,
      },
    ],
  },
];

// 正常成段9：成段同时，多了 新段落，老段落，部分老词sc有更新
export const paragraphNormalBreakFrame9: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 7000,
        et: 8000,
        si: 3,
        tc: "我们看到新段落",
        id: 70,
        pt: 1,
      },
    ],
  },
];

// 正常成段10：成段同时，多了 新段落，但新段落的词不带n字fix标
export const paragraphNormalBreakFrame10: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 1,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 1,
        tc: "总是遗漏",
        id: 60,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 6000,
        et: 7000,
        si: 2,
        tc: "不少",
        id: 70,
      },
    ],
  },
];

// 正常成段11：成段同时，多了 新段落，但新段落的词，部分不带n字fix标，部分带
export const paragraphNormalBreakFrame11: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
      {
        bt: 4000,
        et: 5000,
        si: 1,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 1,
        tc: "总是遗漏",
        id: 60,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 6000,
        et: 7000,
        si: 2,
        tc: "不少",
        id: 70,
      },
      {
        bt: 7000,
        et: 8000,
        si: 3,
        tc: "用户",
        id: 80,
        pt: 1,
      },
    ],
  },
];

// 强制成段1：部分句子挪到pg:2，pt标签不动
export const paragraphForceBreakFrame: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
        pt: 1,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
        pt: 1,
      },
    ],
  },
];

// 强制成段2：部分句子挪到pg:2，pt标签部分动，部分不动
export const paragraphForceBreakFrame2: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
        pt: 1,
      },
    ],
  },
];

// 强制成段3：部分句子挪到pg:2，pt标签部分动，部分不动，且新增word
export const paragraphForceBreakFrame3: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
        pt: 1,
      },
      {
        bt: 6000,
        et: 7000,
        si: 3,
        tc: "不少",
        id: 70,
        pt: 1,
      },
    ],
  },
];

// 强制成段4：部分句子挪到pg:2，原句子无pt，新增word带pt
export const paragraphForceBreakFrame4: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 2,
        tc: "总是遗漏",
        id: 60,
      },
      {
        bt: 6000,
        et: 7000,
        si: 3,
        tc: "不少",
        id: 70,
        pt: 1,
      },
    ],
  },
];

// 强制成段5：部分句子挪到pg:2，原句子无pt，部分word移到新sc
export const paragraphForceBreakFrame5: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 3,
        tc: "总是遗漏",
        id: 60,
        pt: 1,
      },
    ],
  },
];

// 强制成段6：部分句子挪到pg:2，原句子无pt，部分word移到新sc，且sc新增word
export const paragraphForceBreakFrame6: Frames = [
  {
    partial: false,
    pi: "1",
    ui: "1",
    sc: [
      {
        bt: 0,
        et: 1000,
        si: 1,
        tc: "线上",
        id: 10,
      },
      {
        bt: 1000,
        et: 2000,
        si: 1,
        tc: "课程，",
        id: 20,
      },
      {
        bt: 2000,
        et: 3000,
        si: 1,
        tc: "边听",
        id: 30,
      },
      {
        bt: 3000,
        et: 4000,
        si: 1,
        tc: "边记。",
        id: 40,
      },
    ],
  },
  {
    partial: true,
    pi: "2",
    ui: "1",
    sc: [
      {
        bt: 4000,
        et: 5000,
        si: 2,
        tc: "知识点",
        id: 50,
      },
      {
        bt: 5000,
        et: 6000,
        si: 3,
        tc: "总是遗漏",
        id: 60,
        pt: 1,
      },
      {
        bt: 6000,
        et: 7000,
        si: 3,
        tc: "不少",
        id: 70,
        pt: 1,
      },
    ],
  },
];
