import type { ErrorEvent } from "reconnecting-websocket";
import type { Context } from "../context";

type PluginCallback<D = void> = (context: Context, data: D) => void;

export interface Plugin {
  onInit?: PluginCallback;
  onDestroy?: PluginCallback;
  onBeforeStart?: PluginCallback;
  onWsConnect?: PluginCallback;
  onStartAudio?: PluginCallback;
  onBeforeStop?: PluginCallback;
  onStopped?: PluginCallback;
  onStarted?: PluginCallback;
  onError?: PluginCallback<{ type: "recorder" | "connection"; data: Error | ErrorEvent }>;
  onMessage?: PluginCallback<MessageEvent>;
}

export type PluginFactory = (config: Record<string, any>) => Plugin;
