import NoSleep from "nosleep.js";
import { PluginFactory } from "./type";

const noSleep = new NoSleep();
const enableNoSleep = () => {
  document.removeEventListener("click", enableNoSleep, false);
  noSleep.enable();
};

export const NoSleepPlugin: PluginFactory = () => ({
  onStarted() {
    document.addEventListener("click", enableNoSleep, false);
  },
  onStopped() {
    noSleep.disable();
  },
  onError() {
    noSleep.disable();
  },
  onDestroy() {
    noSleep.disable();
  },
});
