import { iAPIResponse } from "./httpInstance/api.type";
import { AxiosInstance } from "./httpInstance/axiosInstance";

interface PostDocChatSyncParams {
  currentDocId: string;
  templateId?: string;
  taskId?: string;
  promptType?: string;
  suggestion?: any;
  index?: number | null;
}

// 获取灵感
const PostGenRelatedQa = <T>(params: PostDocChatSyncParams) => {
  return AxiosInstance.post("api/llm/gen_related_qa", params) as Promise<iAPIResponse<T>>;
};
// 获取十问
const PostGenRelatedQ = <T>(params: PostDocChatSyncParams) => {
  return AxiosInstance.post("api/llm/get_template_q", params) as Promise<iAPIResponse<T>>;
};

export { PostGenRelatedQa, PostGenRelatedQ };
