import copy from "copy-to-clipboard";
import { message } from "@tingwujs/design";

export const copyImgData = async (
  str: string,
  tips: {
    fn: string;
    str: string;
  },
  onCopySuccess: Function | undefined
) => {
  const copyStr = `
    <!DOCTYPE html>
    <html>
      <head>
        <meta charset="utf-8" />
      </head>
      <body>
        <span>${str}</span>
      </body>
    </html>
  `;
  copy(copyStr, { format: "text/html" });
  // @ts-ignore
  message[tips.fn](tips.str);
  onCopySuccess && onCopySuccess();
};
