import styled from "styled-components";
import { Popover } from "@tingwujs/design";

export const XMindStyleText = `
.markmap {
  color: #585A73;
  font-size: 14px;
  line-height: 20px;
  
  .markmap-foreign div {
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: normal;
  }
}
`;

export const LoadingMessage = styled.span`
  color: rgba(39, 38, 77, 0.7);
`;

export const TipsYunWrap = styled.span`
  color: rgba(39, 38, 77, 0.7);
`;

export const Mypopover = styled(Popover)`
  &.ant-popover {
    .ant-popover-content {
      .ant-popover-inner {
        border-radius: 20px;
        border: 1px solid #eaecef;
        box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.04);
        background-color: #fff;
      }
    }
  }
`;

export const XMindWrapper = styled.div<{ isBottom: boolean }>`
  .operateContent {
    position: absolute;
    bottom: ${({ isBottom }) => (isBottom ? "96px" : "24px")};
    left: 28px;
    display: flex;
    align-items: center;
    user-select: none;
    .wrapCom {
      border-radius: 8px;
      box-sizing: border-box;
      border: 1px solid #eaecef;
      color: #1a1a1a;
      background: #fff;
      display: flex;
      align-items: center;
      margin-right: 8px;
      &:last-child {
        margin-right: 0;
      }
      .operateItem {
        margin-right: 8px;
        &:last-child {
          margin-right: 0;
        }
      }
    }

    .pad68 {
      padding: 5px 8px;
    }
    .pad66 {
      padding: 5px;
    }
    .line {
      width: 0;
      height: 14px;
      opacity: 1;
      margin-right: 8px;
      border-right: 1px solid #eaecef;
    }
    .actionItem {
      cursor: pointer;
      color: #1a1a1a;
    }
  }
  .fullScreen {
    opacity: 1;
    cursor: pointer;
  }
  .exportFile {
    height: 32px;
    display: flex;
    padding: 0 15px;
    align-items: center;
    justify-content: center;
    background-color: #eaecef;
    color: #1a1a1a;
    border-radius: 12px;
    font-size: 11px;
    line-height: 16px;
    cursor: pointer;
    user-select: none;
    .operateItem {
      width: 16px;
      height: 16px;
      margin-right: 2px;
      svg {
        color: #1a1a1a;
      }
    }
  }
  .operateLoading {
    background-color: #f7f8fc;
    color: #b2b2b2;
    .operateItem {
      width: 16px;
      height: 16px;
      @keyframes rotation {
        from {
          transform: rotate(0deg);
        }
        to {
          transform: rotate(360deg);
        }
      }
      transform: rotate(360deg);
      animation: rotation 2s linear infinite;
      margin-right: 2px;
      color: #b2b2b2;
    }
  }
  .fullscreenContent {
    position: fixed;
    width: 100vw;
    top: 0;
    left: 0;
    bottom: 0;
    right: 0;
    background-color: #fff;
    z-index: 1000;
    .btnIcon {
      width: 36px;
      height: 36px;
      border-radius: 50%;
      opacity: 1;
      background-color: #fff;
      display: flex;
      align-items: center;
      justify-content: center;
      border: 1px solid #000;
      box-sizing: border-box;
      cursor: pointer;
      margin-left: 12px;

      .operateItem {
        font-size: 20px;
      }

      svg {
        color: #1a1a1a;
      }
      &:hover {
        border: 1px solid #4a4a4a;
        svg {
          color: #4a4a4a;
        }
      }
    }
    .fullScreenWrap {
      position: absolute;
      top: 20px;
      right: 50px;
      display: flex;
    }
    .operateContent {
      bottom: 40px;
      left: 50%;
      transform: translateX(-50%);
      right: initial;
      background: #fff;
    }
  }
  .mindMapContent {
    background: #fff;
    width: 100%;
    overflow: hidden;
    position: relative;
  }
  .wrapperXmind {
    width: 100%;
    background: #fff;
    svg:hover *:not(:hover) {
      pointer-events: auto;
    }
    .markmap-foreign {
      cursor: default;
    }
  }
  .mf8 {
    margin-left: 8px;
  }
  .pd8 {
    padding: 0 8px;
  }
  ${XMindStyleText}
`;
