import { Prepare } from "./prepare";

export class TimeoutPrepare extends Prepare {
  timeout: ReturnType<typeof setTimeout>;

  constructor(timeoutHandler: () => void, during: number) {
    super();
    this.timeout = setTimeout(() => {
      this.reject();
      timeoutHandler();
    }, during);
  }

  resolve() {
    clearTimeout(this.timeout);
    super.resolve();
  }

  reject(reason?: any) {
    clearTimeout(this.timeout);
    super.reject(reason);
  }
}
