import type { MicrophoneOptions } from "./index.type";

export interface iMicrophoneConfigsType {
  [key: string]: MicrophoneOptions;
}

export const microphoneConfigs: iMicrophoneConfigsType = {
  // 高敏感度配置（适合检测细微音量变化）
  highSensitivity: {
    updateInterval: 50,
    fftSize: 512,
    threshold: 5,
    smoothing: 0.2,
    volumeScale: 200,
  },
  // 平衡配置（推荐）
  balanced: {
    updateInterval: 100,
    fftSize: 1024,
    threshold: 10,
    smoothing: 0.4,
    volumeScale: 150,
  },
  // 稳定配置（减少噪声干扰）
  stable: {
    updateInterval: 150,
    fftSize: 2048,
    threshold: 15,
    smoothing: 0.6,
    volumeScale: 100,
  },
  // 实时配置（最快响应）
  realtime: {
    updateInterval: 25,
    fftSize: 256,
    threshold: 3,
    smoothing: 0.1,
    volumeScale: 250,
  },
};
