import { Flex } from "antd";
import styled from "styled-components";

export const UploadFileWrapper = styled(Flex)`
  padding: 26px 32px;
  height: 186px;
  .Upload__Desc {
    font-family: PingFang SC;
    font-size: 14px;
    font-weight: 500;
    line-height: 24px;
    letter-spacing: normal;
    /* 中性色/color-text */
    margin: 8px 0 4px;
    color: var(--Text_Primary); /* rgba(38, 36, 76, 0.88) */
  }

  .ant-upload {
    padding: 0 !important;
  }

  .Upload__Icon {
    font-size: 24px;
    padding: 8px;
    color: var(--Text_Primary); /* rgba(38, 36, 76, 0.88) */
    background: var(--Fill_Background_Light);
    border-radius: 8px;
    height: 40px;
    width: 40px;
    display: flex;
    justify-content: center;
    align-items: center;
  }

  .Upload__Limit {
    font-family: PingFang SC;
    font-size: 12px;
    font-weight: normal;
    line-height: 20px;
    text-align: center;
    letter-spacing: normal;
    /* text/disabled */
    /* 样式描述：gray 500 */
    color: var(--Text_Secondary);
  }

  .Context {
    min-height: 64px;
    /* 自动布局 */
    display: flex;
    align-items: center;
    padding: 10px 12px;
    gap: 16px;
    /* borderRadiusSM */
    border-radius: 6px;
    /* 中性色/color-bg-base */
    background: var(--Fill_Background_Light);
    box-sizing: border-box;
    /* 中性色/color-border-secondary */
    border: 1px solid var(--Line_Light);

    &__Name {
      /* Body/medium */
      font-family: PingFang SC;
      font-size: 14px;
      font-weight: 500;
      line-height: 24px;
      letter-spacing: normal;
      /* 主题色/color-text */
      color: var(--Text_Primary);
    }

    &__Progress {
      display: inline-block;
      width: 100%;
    }
    &__Text {
      /* Footnote/regular */
      font-family: PingFang SC;
      font-size: 12px;
      font-weight: normal;
      line-height: 20px;
      letter-spacing: normal;
      /* 中性色/color-text-tertiary */
      color: var(--Text_Caption);
    }
    &__Text1 {
      /* Footnote/regular */
      font-family: PingFang SC;
      font-size: 12px;
      font-weight: normal;
      line-height: 20px;
      letter-spacing: normal;
      /* 状态色/color-error */
      color: var(--Danger);
    }
  }
`;

export const CoverFileInfoWrapper = styled(Flex)`
  position: absolute;
  left: 0;
  top: 0;
  border-radius: var(--border-radius); /* 6px */
  /* 中性色/color-fill-tertiary */
  background: #fff;
  box-sizing: border-box;
  /* 中性色/color-border-secondary */
  border: 1px dashed #e6e8ee;
  width: 100%;
  height: 100%;

  .UploadFileThumbnail {
    width: 40px;
    height: 40px;
    &__Img {
      width: 100%;
      height: 100%;
      object-fit: contain;
    }
  }

  .UploadFileName {
    /* Footnote/medium */
    font-family: PingFang SC;
    font-size: 12px;
    font-weight: 500;
    line-height: 20px;
    letter-spacing: normal;
    /* 中性色/color-text */
    color: var(--Text_Primary); /* rgba(38, 36, 76, 0.88) */
    margin: 16px 0 8px;
    width: 100%;

    &__Cancel {
      font-family: PingFang SC;
      font-size: 12px;
      font-weight: normal;
      line-height: 20px;
      letter-spacing: normal;
      /* 中性色/color-text-tertiary */
      color: rgba(38, 36, 76, 0.45);
      cursor: pointer;
    }

    &__Text {
      max-width: calc(100% - 100px);
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    &__Error {
      font-family: PingFang SC;
      font-size: 12px;
      font-weight: 500;
      line-height: 20px;
      letter-spacing: normal;
      /* 状态色/color-error */
      color: #ff4d4f;
    }
  }
`;

export const UploadErrorMessage = styled(Flex)`
  font-family: PingFang SC;
  font-size: 12px;
  font-weight: normal;
  line-height: 20px;
  letter-spacing: normal;
  /* 中性色/color-text-secondary */
  color: rgba(38, 36, 76, 0.65);
  position: relative;
  top: -4px;
`;
