import React from "react";

export interface iMultiMediaResourceType {
  taskType: string;
  fileUniqueId: string;
  fileSize: number;
  fileContentType: string;
  fileName?: string;
}

export enum eUploadStatusType {
  IDLE = "IDLE", // 未开始上传
  START = "START", // 开始上传
  RUNNING = "RUNNING", // 上传中
  FAILED = "FAILED", // 上传失败
  FINISH = "FINISH", // 上传完成
}

export interface iUploadFileValueType {
  fileUrl?: string;
  fileId?: string;
  fileName?: string;
  fileSize?: number;
  errorMsg?: string;
  uploadStatus?: eUploadStatusType;
  progress?: number;
}

export interface iUploadFilePropsType {
  disabled?: boolean;
  maxSize?: number; // 最大文件大小，默认6GB
  accept?: string;
  value?: iUploadFileValueType;
  describe?: React.ReactNode;
  title?: React.ReactNode;
  uploadIcon?: React.ReactNode;
  fileStatusPosition?: "footer" | "cover";
  confirmText?: string;
  confirmDataAutolog?: string;
  onConfirmHandler?: (file: iUploadFileValueType) => void;
  uploadTFile?: (data: any) => any;
  onChange?: (value: iUploadFileValueType) => void;
  uploadDataHandler?: (file: any) => void;
  onPreVerifyHandler?: () => Promise<boolean>; // 预验证
  onClickContainerHandler?: () => void;
}
