import styled from "styled-components";

export const MicrophonePermissionCheckWrapper = styled.div`
  border-radius: 8px;
  background:
    linear-gradient(180deg, rgba(240, 240, 243, 0.73) -5%, rgba(255, 255, 255, 0) 100%), #fff;
  box-sizing: border-box;
  /* 中性色/color-border-secondary */
  border: 1px solid var(--Line_Light);
  /* 阴影/box-shadow-secondary */
  box-shadow:
    0px 12px 24px -16px rgba(0, 0, 0, 0.06),
    0px 8px 40px 0px rgba(0, 0, 0, 0.12),
    0px 0px 1px 0px rgba(0, 0, 0, 0.04);
  width: 296px;
  display: flex;
  align-items: center;
  flex-direction: column;
  padding: 143px 26px 24px;
  position: relative;
  background-image: url(https://img.alicdn.com/imgextra/i2/O1CN01Y1QxKG2AGfJmTHlI8_!!6000000008176-2-tps-640-656.png);
  background-size: cover;
  background-position-x: center;

  .MicrophonePermissionCheck__Title {
    font-family: PingFang SC;
    font-size: 16px;
    font-weight: 500;
    line-height: 24px;
    text-align: center;
    letter-spacing: normal;
    /* 中性色/color-text */
    color: var(--Text_Primary);
    margin-bottom: 8px;
  }

  .MicrophonePermissionCheck__Describe {
    font-family: PingFang SC;
    font-size: 12px;
    font-weight: normal;
    line-height: 20px;
    text-align: center;
    letter-spacing: normal;
    margin-bottom: 12px;
    color: var(--Text_Caption);

    .MicrophonePermissionCheck__Describe__Enabled {
      color: var(--Text_Secondary);
    }
  }

  .StartMicBtn {
    width: 100%;
    margin-top: 25px;
  }

  .MicrophoneOpen__Tip {
    background: var(--Pending);
    width: 6px;
    height: 6px;
    border-radius: 3px;
  }

  .MicrophoneOpen__Tip__Enabled {
    /* 状态色/color-success */
    background: var(--Success);
  }

  .MicrophoneOpen__Describe {
    /* Footnote/regular */
    font-family: PingFang SC;
    font-size: 12px;
    font-weight: normal;
    line-height: 20px;
    letter-spacing: normal;
    /* 中性色/color-text-tertiary */
    color: var(--Text_Caption);
  }

  .MicrophoneOpen__Btn {
    /* Footnote/medium */
    font-family: PingFang SC;
    font-size: 12px;
    font-weight: 500;
    line-height: 20px;
    letter-spacing: normal;
    /* 中性色/color-text */
    color: var(--Text_Primary);
    cursor: pointer;
  }
`;
