import styled from "styled-components";

export const Panel = styled.div`
  position: relative;
  width: 100%;
  height: 100%;
  border-radius: 6px;
  overflow: hidden;
  background: var(--Fill_Background_Light);
  .canvas {
    position: absolute;
    inset: 0;
    display: block;
    width: 100%;
    height: 100%;
    background: var(--Fill_Tertiary);
  }

  .fadeLeft {
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 56px;
    pointer-events: none;
    background: linear-gradient(90deg, #f8f8fa 16%, rgba(248, 248, 250, 0) 100%);
  }

  .centerCap {
    position: absolute;
    top: 0;
    left: calc(50% + 0.5px);
    transform: translateX(-50%);
    width: 8px;
    height: 5px;
    background: var(--Fill_Brand_Primary);
  }
`;
