import { useMemo } from "react";
import { MarkdownController } from "./libs/controller";
import {
  extBlockquote,
  extEmphasis,
  extHeading1,
  extHeading2,
  extHeading3,
  extHeading4,
  extHeading5,
  extHeading6,
  extImage,
  extInlineCode,
  extLink,
  extList,
  extMath,
  extParagraph,
  extStrong,
  extTable,
  extText,
  extThematicBreak,
} from "./extensions";

export function useMDController() {
  return useMemo(() => {
    const controller = new MarkdownController();
    controller.setExtensions([
      extHeading1,
      extHeading2,
      extHeading3,
      extHeading4,
      extHeading5,
      extHeading6,
      extParagraph,
      extStrong,
      extEmphasis,
      extBlockquote,
      extList,
      extInlineCode,
      extText,
      extThematicBreak,
      extLink,
      extImage,
      extMath,
      extTable,
    ]);
    return controller;
  }, []);
}
