import React from "react";
import { createRenderExtension } from "./base";
import { Paragraph } from "../styled";

export const extParagraph = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "paragraph") {
      return <Paragraph>{controller.renderChildren(content.children)}</Paragraph>;
    }
    return next();
  },
});
