import React from "react";
import { createRenderExtension } from "./base";

export const extLink = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "link") {
      return (
        <a href={content.url} title={content.title ?? ""}>
          {controller.renderChildren(content.children)}
        </a>
      );
    }
    return next();
  },
});
