import React from "react";
import { createRenderExtension } from "./base";
import { Image } from "../styled";

export const extImage = createRenderExtension({
  renderContent(_controller, content, next) {
    if (content.type === "image") {
      return (
        <Image
          src={content.url}
          style={{
            maxWidth: "100%",
          }}
        />
      );
    }
    return next();
  },
});
