import React from "react";
import { createRenderExtension } from "./base";
import { Heading1, Heading2, Heading3, Heading4, Heading5, Heading6 } from "../styled";

export const extHeading1 = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "heading" && content.depth === 1) {
      return <Heading1>{controller.renderChildren(content.children)}</Heading1>;
    }
    return next();
  },
});

export const extHeading2 = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "heading" && content.depth === 2) {
      return <Heading2>{controller.renderChildren(content.children)}</Heading2>;
    }
    return next();
  },
});

export const extHeading3 = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "heading" && content.depth === 3) {
      return <Heading3>{controller.renderChildren(content.children)}</Heading3>;
    }
    return next();
  },
});

export const extHeading4 = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "heading" && content.depth === 4) {
      return <Heading4>{controller.renderChildren(content.children)}</Heading4>;
    }
    return next();
  },
});

export const extHeading5 = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "heading" && content.depth === 5) {
      return <Heading5>{controller.renderChildren(content.children)}</Heading5>;
    }
    return next();
  },
});

export const extHeading6 = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "heading" && content.depth === 6) {
      return <Heading6>{controller.renderChildren(content.children)}</Heading6>;
    }
    return next();
  },
});
