export interface CommonRange<T = number> {
  start: T;
  end: T;
}

export const isIntersectRanges = (range1: CommonRange, range2: CommonRange) => {
  // 计算两个区间[a,b] [c,d]是否有重叠, 通过判断min(b,d) > max(a,c)来判断是否重叠
  return Math.min(range1.end, range2.end) > Math.max(range1.start, range2.start);
};
