import dayjs from "dayjs";
import duration from "dayjs/plugin/duration";

dayjs.extend(duration);

export const getHours = (ms: number) => {
  return Math.trunc(dayjs.duration(ms).asHours());
};

export const getMinutes = (ms: number) => {
  return Math.trunc(dayjs.duration(ms).asMinutes());
};

export const convertMsToTime = (ms: number) => {
  return dayjs.duration(ms).format("HH:mm:ss");
};

export const convertMsToHHMM = (ms: number) => {
  return dayjs.duration(ms).format("HH:mm");
};

const oneHour = 3600 * 1000;

export const isOverOneHour = (ms: number) => {
  return ms >= oneHour;
};

export const getFlexibleTime = (ms: number) => {
  if (isOverOneHour(ms)) {
    return dayjs.duration(ms).format("HH:mm:ss");
  } else {
    return dayjs.duration(ms).format("mm:ss");
  }
};
