import {
  isEnterHotkey,
  isDeleteHotkey,
  isBackspaceHotkey,
  isSpaceHotKey,
} from '../keyboard';
import { KEY_CODES } from '../constants';

describe('keyboard', () => {
  describe('isEnterHotkey', () => {
    it('should return true for Enter key code', () => {
      expect(isEnterHotkey(KEY_CODES.Enter)).toBe(true);
    });

    it('should return false for other key codes', () => {
      expect(isEnterHotkey(KEY_CODES.Space)).toBe(false);
      expect(isEnterHotkey(KEY_CODES.Delete)).toBe(false);
    });
  });

  describe('isDeleteHotkey', () => {
    it('should return true for Delete key code', () => {
      expect(isDeleteHotkey(KEY_CODES.Delete)).toBe(true);
    });

    it('should return false for other key codes', () => {
      expect(isDeleteHotkey(KEY_CODES.Backspace)).toBe(false);
      expect(isDeleteHotkey(KEY_CODES.Enter)).toBe(false);
    });
  });

  describe('isBackspaceHotkey', () => {
    it('should return true for Backspace key code', () => {
      expect(isBackspaceHotkey(KEY_CODES.Backspace)).toBe(true);
    });

    it('should return false for other key codes', () => {
      expect(isBackspaceHotkey(KEY_CODES.Delete)).toBe(false);
      expect(isBackspaceHotkey(KEY_CODES.Enter)).toBe(false);
    });
  });

  describe('isSpaceHotKey', () => {
    it('should return true for Space key code', () => {
      expect(isSpaceHotKey(KEY_CODES.Space)).toBe(true);
    });

    it('should return false for other key codes', () => {
      expect(isSpaceHotKey(KEY_CODES.Enter)).toBe(false);
      expect(isSpaceHotKey(KEY_CODES.Delete)).toBe(false);
    });
  });
});

