import { getHighlightFragments } from '../highlight';

describe('highlight', () => {
  describe('getHighlightFragments', () => {
    it('should split text by keyword and mark keywords', () => {
      const result = getHighlightFragments('Hello World', 'World');
      // split('Hello World', 'World') = ['Hello ', ''] - 注意 split 会在末尾添加空字符串
      expect(result.length).toBeGreaterThanOrEqual(2);
      expect(result[0]).toEqual({ title: 'Hello ', isKeyword: false });
      expect(result[1]).toEqual({ title: 'World', isKeyword: true });
    });

    it('should handle multiple occurrences of keyword', () => {
      const result = getHighlightFragments('test test test', 'test');
      // split('test test test', 'test') = ['', ' ', ' ', '']
      expect(result.length).toBeGreaterThanOrEqual(6);
      expect(result[0]).toEqual({ title: '', isKeyword: false });
      expect(result[1]).toEqual({ title: 'test', isKeyword: true });
      expect(result[2]).toEqual({ title: ' ', isKeyword: false });
      expect(result[3]).toEqual({ title: 'test', isKeyword: true });
      expect(result[4]).toEqual({ title: ' ', isKeyword: false });
      expect(result[5]).toEqual({ title: 'test', isKeyword: true });
    });

    it('should handle keyword at the start', () => {
      const result = getHighlightFragments('Hello World', 'Hello');
      expect(result.length).toBeGreaterThanOrEqual(2);
      expect(result[0]).toEqual({ title: '', isKeyword: false });
      expect(result[1]).toEqual({ title: 'Hello', isKeyword: true });
    });

    it('should handle keyword at the end', () => {
      const result = getHighlightFragments('Hello World', 'World');
      expect(result.length).toBeGreaterThanOrEqual(2);
      expect(result[0]).toEqual({ title: 'Hello ', isKeyword: false });
      expect(result[1]).toEqual({ title: 'World', isKeyword: true });
    });

    it('should handle empty keyword by splitting on each character', () => {
      const result = getHighlightFragments('Hello World', '');
      // split('Hello World', '') splits on every character
      expect(result.length).toBeGreaterThan(1);
      expect(result[0].isKeyword).toBe(false);
    });

    it('should handle keyword not found', () => {
      const result = getHighlightFragments('Hello World', 'NotFound');
      expect(result).toEqual([
        { title: 'Hello World', isKeyword: false },
      ]);
    });

    it('should handle empty text', () => {
      const result = getHighlightFragments('', 'test');
      expect(result).toEqual([
        { title: '', isKeyword: false },
      ]);
    });

    it('should handle Chinese text', () => {
      const result = getHighlightFragments('你好世界', '世界');
      expect(result.length).toBeGreaterThanOrEqual(2);
      expect(result[0]).toEqual({ title: '你好', isKeyword: false });
      expect(result[1]).toEqual({ title: '世界', isKeyword: true });
    });
  });
});

