import {
  convertMsToTime,
  getFlexibleTime,
  getHours,
  getMinutes,
  convertMsToHHMM,
  isOverOneHour,
} from "../datetime";

describe("datetime", () => {
  describe("convertMsToTime", () => {
    it("should convert milliseconds to HH:mm:ss format", () => {
      expect(convertMsToTime(1000)).toBe("00:00:01");
      expect(convertMsToTime(52970)).toBe("00:00:52");
      expect(convertMsToTime(3661000)).toBe("01:01:01");
      expect(convertMsToTime(0)).toBe("00:00:00");
    });
  });

  describe("convertMsToHHMM", () => {
    it("should convert milliseconds to HH:mm format", () => {
      expect(convertMsToHHMM(1000)).toBe("00:00");
      expect(convertMsToHHMM(60000)).toBe("00:01");
      expect(convertMsToHHMM(3661000)).toBe("01:01");
      expect(convertMsToHHMM(0)).toBe("00:00");
    });
  });

  describe("getFlexibleTime", () => {
    it("should return mm:ss format for time less than one hour", () => {
      expect(getFlexibleTime(0)).toBe("00:00");
      expect(getFlexibleTime(1000)).toBe("00:01");
      expect(getFlexibleTime(52970)).toBe("00:52");
      expect(getFlexibleTime(3599000)).toBe("59:59");
    });

    it("should return HH:mm:ss format for time over one hour", () => {
      expect(getFlexibleTime(3600000)).toBe("01:00:00");
      expect(getFlexibleTime(3610000)).toBe("01:00:10");
      expect(getFlexibleTime(7323000)).toBe("02:02:03");
    });
  });

  describe("getHours", () => {
    it("should return hours from milliseconds", () => {
      expect(getHours(0)).toBe(0);
      expect(getHours(3600000)).toBe(1);
      expect(getHours(7200000)).toBe(2);
      expect(getHours(3661000)).toBe(1);
      expect(getHours(3599000)).toBe(0);
    });
  });

  describe("getMinutes", () => {
    it("should return minutes from milliseconds", () => {
      expect(getMinutes(0)).toBe(0);
      expect(getMinutes(60000)).toBe(1);
      expect(getMinutes(120000)).toBe(2);
      expect(getMinutes(3661000)).toBe(61);
      expect(getMinutes(3599000)).toBe(59);
    });
  });

  describe("isOverOneHour", () => {
    it("should return true for time over one hour", () => {
      expect(isOverOneHour(3600000)).toBe(true);
      expect(isOverOneHour(3600001)).toBe(true);
      expect(isOverOneHour(7200000)).toBe(true);
    });

    it("should return false for time less than one hour", () => {
      expect(isOverOneHour(0)).toBe(false);
      expect(isOverOneHour(1000)).toBe(false);
      expect(isOverOneHour(3599000)).toBe(false);
    });
  });
});
