import { test, expect } from '@playwright/test';

test.describe('Tingwu Application E2E Tests', () => {
  test.beforeEach(async ({ page }) => {
    await page.goto('/');
  });

  test('should load the application', async ({ page }) => {
    // Wait for the page to load
    await page.waitForLoadState('networkidle');
    
    // Check if the page title or main content is visible
    const body = page.locator('body');
    await expect(body).toBeVisible();
  });

  test('should display experience center on home page', async ({ page }) => {
    await page.waitForLoadState('networkidle');
    
    // Check if main content is rendered
    const mainContent = page.locator('body');
    await expect(mainContent).toBeVisible();
  });

  test('should navigate to details page', async ({ page }) => {
    // This test assumes there's a way to navigate to details
    // Adjust based on actual application flow
    await page.waitForLoadState('networkidle');
    
    // Example: if there's a link or button to navigate
    // const detailsLink = page.locator('[data-testid="details-link"]');
    // if (await detailsLink.isVisible()) {
    //   await detailsLink.click();
    //   await expect(page).toHaveURL(/\/details\//);
    // }
  });

  test('should handle API configuration', async ({ page }) => {
    await page.waitForLoadState('networkidle');
    
    // Check if the page loads without errors
    // In a real scenario, you might check for error messages
    const errorMessages = page.locator('[role="alert"]');
    const errorCount = await errorMessages.count();
    
    // If API keys are not configured, there might be error messages
    // This is expected behavior, so we just verify the page doesn't crash
    await expect(page.locator('body')).toBeVisible();
  });
});

