# 听悟大模型智能纪要示例应用开发文档

[English Version](README-DEV.en.md) | [中文版本](README-DEV.md)

> **说明**: 本文档是 `tingwu-example` 包的详细开发及技术细节。

## 🚀 快速开始

### 环境要求

- **Node.js**: 版本 ≥ 18.0.0

### 启动步骤

1. **安装依赖**

   ```bash
   npm install
   ```

2. **配置 API 密钥**

   编辑 `.env` 文件，配置你的 API Key 和 App ID：

   ```typescript
   REACT_APP_API_KEY = xxxxx;
   REACT_APP_APP_ID = xxxxx;
   ```

3. **启动应用**

   ```bash
   npm run dev
   ```

4. **访问应用**

   打开浏览器访问：`http://localhost:3000`

## 📋 功能说明

本示例应用展示了听悟大模型智能纪要的核心功能：

<div align="center">
  <img src="./images/workflow.png" alt="工作流" width="950">
</div>

### 🎵 音视频文件上传

**功能**: 上传音频或视频文件，自动进行语音识别和转录

**使用流程**:

1. 点击"选择文件"按钮，选择要上传的音频/视频文件
2. 文件上传到自己业务的 oss或服务器。
3. 创建任务createTask，调用接口中涉及的apiKey和appId，需替换成自己的。parameters和analysis参数自定义。

**代码示例**:

```javascript
const { output, code } = await createTaskAPI({
  input: {
    task: "createTask",
    type: "offline",
    fileUrl, //文件上传到自己业务的 oss或服务器 后得到的文件链接
    appId: "你的APP_ID",
  },
  parameters: {
    transcription: {
      diarizationEnabled: true,
      diarizationSpeakerCount: 0,
      translationEnabled: false,
    },
    analysis: {},
  },
});
```

第4步： 调用getTask，获取任务解析状态。参数中的dataId来自createTask接口的返回值。

### 🎤 实时录音

**功能**: 实时语音识别，边说边转录

第1步：开始录音，校验浏览器的麦克风权限，确保麦克风权限开启

第2步：创建任务createTask，调用接口中涉及的apiKey和appId，需替换成自己的。parameters和analysis参数自定义
**代码示例**:

```javascript
const requestParams = {
  input: {
    task: "createTask",
    type: "realtime",
    format: "pcm",
    sampleRate: 16000,
    appId: "你的APP_ID",
  },
  parameters: {
    transcription: {
      model: language,
      diarizationEnabled: true,
      diarizationSpeakerCount: 0,
      translationTargetLang: "zh",
      translationEnabled: true,
    },
    analysis: {},
  },
};
```

第3步：websocket建联，增加了心跳机制，链接报错，重新链接超过3次不再重连。

两种方案： 1. wss链接由服务端返回 2. wss链接由前端拼接，token由服务端返回。 demo中使用第二种方式。token使用的是临时token，但临时token只有1分钟的有效期，因此每次断联重新链接后需重新获取临时token。

第4步： 调用getTask，获取任务解析状态。参数中的dataId来自createTask接口的返回值。

### 📄 智能纪要整理

**功能**: 查看完整的转录结果、摘要、问答、思维导图等能力

**包含内容**:

- **转录文本**: 完整的语音转文字结果
- **说话人分离**: 区分不同说话人的内容
- **智能摘要**: 自动生成内容摘要
- **问答回顾**: 提取关键问题和答案
- **章节速览**: 按时间或内容分段浏览
- **翻译功能**: 支持多语言翻译（如果开启）

**注意事项**:

- 文本类型文件不支持音频回放和回溯功能
- 配置参数需要在创建任务时设置
- 支持自定义分析参数

**代码中的使用**:

- 调用getTask，获取详情页数据。参数中的dataId来自createTask接口的返回值。
- 注意事项： getTask接口未返回配置参数和文件类型，需根据createTask接口的自定义配置选项设置对应的参数。
- 包含：
  - 1.是否开启翻译、翻译源语言、翻译目标语言、是否打开原文内容改写等。
  - 2.文件类型设置：如果为文本生成，详情页不显示音频区、不支持章节速览和问答回顾的回溯功能。
  - 3.文本类型："TEXT_FILE" 或 "TEXT_FILE_REUSE"

## 🔧 开发说明

### 项目结构

```
tingwu-example/
├── src/
│   ├── App.tsx          # 主应用组件
│   ├── main.tsx         # 应用入口
│   └── index.css        # 样式文件
├── package.json         # 项目配置
└── vite.config.ts      # Vite 配置
```

### 主要依赖

- **React 18**: 前端框架
- **Ant Design**: UI 组件库
- **Vite**: 构建工具
- **听悟组件**: 核心功能组件

### 开发命令

- `npm run dev`: 启动开发服务器
- `npm run build`: 构建生产版本
- `npm run preview`: 预览构建结果
- `npm run lint`: 代码检查

## ⚠️ 重要提醒

1. **API 配置**: 使用前必须配置正确的 API Key 和 App ID
2. **浏览器权限**: 实时录音需要麦克风权限
3. **网络环境**: 需要稳定的网络连接访问阿里云服务
4. **HTTPS 要求**: 生产环境建议使用 HTTPS 协议
