# 听悟大模型前端项目 - 系统架构图

[English Version](ARCHITECTURE.en.md) | [中文版本](ARCHITECTURE.md)

## 项目概述

听悟大模型前端项目是一个基于 Monorepo 架构的 React 应用，使用 Lerna 进行多包管理。项目主要提供音视频转录、实时录音、智能纪要等核心功能。

## 系统架构图

```mermaid
graph TB
    subgraph "应用层 (Application Layer)"
        Example["@tingwu/example<br/>示例应用<br/>(主入口)"]
        Home["@tingwu/home<br/>主页应用<br/>(配置页)"]
    end

    subgraph "功能层 (Feature Layer)"
        Summary["@tingwu/summary<br/>智能纪要详情页<br/>(DVA + Recoil)"]
        Transcription["@tingwu/transcription<br/>转录功能模块"]
        Sphere["@tingwu/sphere<br/>功能模块"]
    end

    subgraph "组件层 (Component Layer)"
        Components["@tingwu/components<br/>UI组件库<br/>(Markdown/QR等)"]
        MeetingIcon["@tingwu/meeting-icon<br/>会议图标"]
    end

    subgraph "核心层 (Core Layer)"
        Core["@tingwu/core<br/>核心逻辑<br/>(Controller/Model/Editor)"]
        CoreASR["@tingwu/core-asr<br/>ASR核心<br/>(语音识别)"]
        Service["@tingwu/service<br/>API服务层"]
    end

    subgraph "基础层 (Foundation Layer)"
        Common["@tingwu/common<br/>通用工具<br/>(Hooks/Utils)"]
        Util["@tingwu/util<br/>工具函数"]
        Design["@tingwu/design<br/>设计系统<br/>(主题/样式)"]
    end

    subgraph "外部服务 (External Services)"
        AliyunAPI["阿里云百炼API<br/>(API Key + App ID)"]
    end

    %% 应用层依赖
    Example --> Home
    Example --> CoreASR
    Example --> Summary
    Example --> Service
    Home --> Components
    Home --> Service
    Home --> Summary
    Home --> Design

    %% 功能层依赖
    Summary --> Common
    Summary --> Components
    Summary --> Core
    Summary --> Design
    Summary --> MeetingIcon
    Summary --> Service
    Summary --> Sphere
    Summary --> Transcription
    Summary --> Util

    Transcription --> Common
    Transcription --> Core
    Transcription --> Design
    Transcription --> MeetingIcon
    Transcription --> Sphere
    Transcription --> Util

    Sphere --> Common
    Sphere --> Core
    Sphere --> Design
    Sphere --> Util

    %% 组件层依赖
    Components --> Common
    Components --> CoreASR
    Components --> Design
    Components --> Util

    %% 核心层依赖
    Core --> Common
    CoreASR --> CoreASRModule["独立模块 (WebSocket/Recorder)"]

    %% 基础层（无内部依赖）
    Common --> CommonModule["React Hooks / 浏览器API / 工具函数"]
    Util --> UtilModule["工具函数"]
    Design --> DesignModule["主题系统 / 样式组件"]

    %% 外部服务连接
    Service --> AliyunAPI
    CoreASR --> AliyunAPI

    %% 样式
    classDef appLayer fill:#e1f5ff,stroke:#01579b,stroke-width:2px
    classDef featureLayer fill:#f3e5f5,stroke:#4a148c,stroke-width:2px
    classDef componentLayer fill:#e8f5e9,stroke:#1b5e20,stroke-width:2px
    classDef coreLayer fill:#fff3e0,stroke:#e65100,stroke-width:2px
    classDef foundationLayer fill:#fce4ec,stroke:#880e4f,stroke-width:2px
    classDef external fill:#ffebee,stroke:#b71c1c,stroke-width:2px

    class Example,Home appLayer
    class Summary,Transcription,Sphere featureLayer
    class Components,MeetingIcon componentLayer
    class Core,CoreASR,Service coreLayer
    class Common,Util,Design foundationLayer
    class AliyunAPI external
```

## 架构分层说明

### 1. 基础层 (Foundation Layer)
提供最基础的通用功能和工具，不依赖其他内部包。

- **@tingwu/common**: 通用工具和 React Hooks
  - 浏览器 API 封装
  - 常用工具函数
  - React Hooks (如 useSyncEffect)
  
- **@tingwu/util**: 纯工具函数库
  - 无依赖的工具函数集合
  
- **@tingwu/design**: 设计系统
  - 主题配置
  - 样式组件
  - 颜色系统

### 2. 核心层 (Core Layer)
提供核心业务逻辑和服务能力。

- **@tingwu/core**: 核心业务逻辑
  - Controller: 控制器逻辑
  - Model: 数据模型
  - Editor: 编辑器功能
  - Persist: 持久化
  
- **@tingwu/core-asr**: ASR（自动语音识别）核心
  - 音频录制
  - WebSocket 连接
  - 语音识别处理
  - 独立模块，不依赖其他内部包
  
- **@tingwu/service**: API 服务层
  - 封装与阿里云百炼 API 的交互
  - HTTP 请求处理
  - 独立模块

### 3. 组件层 (Component Layer)
提供可复用的 UI 组件。

- **@tingwu/components**: UI 组件库
  - Markdown 渲染
  - QR 码生成
  - 各种业务组件
  
- **@tingwu/meeting-icon**: 会议图标组件

### 4. 功能层 (Feature Layer)
提供完整的业务功能模块。

- **@tingwu/summary**: 智能纪要详情页
  - 使用 DVA + Recoil 进行状态管理
  - 整合多个功能模块
  - 最复杂的业务模块
  
- **@tingwu/transcription**: 转录功能模块
  - 音视频转录处理
  
- **@tingwu/sphere**: 功能模块
  - 特定业务功能实现

### 5. 应用层 (Application Layer)
最终的应用入口。

- **@tingwu/home**: 主页应用
  - 开启智能纪要的配置页
  - 使用 Vite 构建
  
- **@tingwu/example**: 示例应用
  - 主启动入口
  - 路由配置
  - 整合 home 和 summary

## 技术栈

### 构建工具
- **Lerna**: Monorepo 管理
- **Vite**: 应用构建工具
- **Father**: 库构建工具
- **TypeScript**: 类型系统

### 前端框架
- **React 18**: UI 框架
- **React Router**: 路由管理
- **Ant Design 5**: UI 组件库
- **Styled Components**: CSS-in-JS

### 状态管理
- **DVA**: 基于 Redux 的状态管理（summary 模块）
- **Recoil**: 原子化状态管理（summary 模块）
- **Valtio**: 代理式状态管理（components 模块）

### 核心功能
- **WebSocket**: 实时通信（ASR）
- **MediaRecorder API**: 音频录制
- **阿里云百炼 API**: AI 服务

## 数据流向

```
用户操作
  ↓
应用层 (example/home)
  ↓
功能层 (summary/transcription)
  ↓
组件层 (components)
  ↓
核心层 (core/core-asr/service)
  ↓
基础层 (common/util/design)
  ↓
外部服务 (阿里云百炼 API)
```

## 模块依赖关系

### 依赖层级（从下往上）

1. **基础层** → 无内部依赖
2. **核心层** → 依赖基础层
3. **组件层** → 依赖核心层 + 基础层
4. **功能层** → 依赖组件层 + 核心层 + 基础层
5. **应用层** → 依赖所有下层

### 关键依赖路径

- `example` → `home` → `summary` → `components` → `core` → `common`
- `example` → `core-asr` (独立)
- `summary` → `transcription` → `sphere` → `core` → `common`
- `components` → `core-asr` → WebSocket/Recorder

## 开发建议

1. **基础层**: 保持纯净，不依赖其他内部包
2. **核心层**: 专注于业务逻辑，避免 UI 相关代码
3. **组件层**: 提供可复用的 UI 组件
4. **功能层**: 整合组件和核心逻辑，实现完整功能
5. **应用层**: 负责路由和页面组织

## 扩展性

- 新增功能模块：在功能层添加新包
- 新增组件：在组件层添加
- 新增工具：在基础层添加
- 新增服务：在核心层添加

