# 测试指南

本文档说明如何运行项目的单元测试和 E2E 测试。

## 📋 目录

- [单元测试](#单元测试)
- [E2E 测试](#e2e-测试)
- [测试覆盖率](#测试覆盖率)
- [编写测试](#编写测试)

## 单元测试

### 前置准备

在运行测试之前，请确保已安装所有依赖：

```bash
# 在项目根目录
npm install
```

### 运行所有测试

```bash
# 在项目根目录
npm run test
```

### 监听模式运行测试

```bash
npm run test:watch
```

### 生成覆盖率报告

```bash
npm run test:coverage
```

### 运行特定包的测试

有两种方式：

**方式 1: 从根目录运行（推荐）**
```bash
# 在项目根目录
npm run test -- packages/tingwu-common
```

**方式 2: 在包目录下运行**
```bash
cd packages/tingwu-common
npm run test
```

> **注意**: 
> - 如果遇到 "jest: command not found" 错误，请确保已在根目录运行 `npm install` 安装依赖
> - 如果遇到 npm 权限错误（EACCES），请参考 [修复 npm 权限问题文档](../docs/FIX-NPM-PERMISSIONS.zh.md)

## E2E 测试

E2E 测试使用 Playwright 进行端到端测试。

### 安装 Playwright 浏览器

首次运行前需要安装浏览器：

```bash
npx playwright install
```

### 运行 E2E 测试

```bash
npm run test:e2e
```

### 以 UI 模式运行 E2E 测试

```bash
npm run test:e2e:ui
```

### 调试模式运行 E2E 测试

```bash
npm run test:e2e:debug
```

### 运行所有测试（单元测试 + E2E）

```bash
npm run test:all
```

## 测试覆盖率

项目使用 Jest 收集测试覆盖率。覆盖率报告会生成在 `coverage/` 目录下。

### 查看覆盖率报告

运行 `npm run test:coverage` 后，打开 `coverage/lcov-report/index.html` 查看详细报告。

### 覆盖率目标

- 语句覆盖率: ≥ 70%
- 分支覆盖率: ≥ 60%
- 函数覆盖率: ≥ 70%
- 行覆盖率: ≥ 70%

## 编写测试

### 单元测试

单元测试文件应放在 `src/__tests__/` 目录下，命名格式为 `*.test.ts` 或 `*.test.tsx`。

#### 示例

```typescript
import { functionToTest } from '../module';

describe('Module', () => {
  it('should work correctly', () => {
    expect(functionToTest()).toBe(expectedValue);
  });
});
```

### E2E 测试

E2E 测试文件应放在 `e2e/tests/` 目录下，命名格式为 `*.spec.ts`。

#### 示例

```typescript
import { test, expect } from '@playwright/test';

test('should load page', async ({ page }) => {
  await page.goto('/');
  await expect(page.locator('body')).toBeVisible();
});
```

## 测试最佳实践

1. **测试命名**: 使用描述性的测试名称
2. **测试隔离**: 每个测试应该独立运行
3. **Mock 外部依赖**: 使用 Jest mocks 模拟外部 API 和依赖
4. **覆盖率**: 优先测试核心功能和边界情况
5. **E2E 测试**: 关注关键用户流程，避免测试过多细节

## CI/CD

测试会在 GitHub Actions 中自动运行：
- 每次 push 到 main/develop 分支
- 每次创建 Pull Request

查看 `.github/workflows/test.yml` 了解详细配置。

