# Tingwu AI Frontend Project

[English Version](README.en.md) | [中文版本](README.md)

## 📋 Features

This project includes the following core features:

### 🎵 Audio/Video File Upload

Supports uploading audio/video files for offline transcription

### 🎤 Real-time Recording

Supports real-time speech recognition and transcription

### 📄 Intelligent Meeting Summary Results Page

- **Real-time Recording Intelligent Summary**: In scenarios where users speak in real-time, promptly record the corresponding information of user speeches
  - Core is based on frontend media technology, through audio collection and audio/video communication transcription, automatically converting user speech into text summaries
- **Offline Summary Organization**: Through various AI intelligent extensions, help users efficiently and quickly organize summaries
  - Currently supports 2 major types: 1) Real-time recording intelligent summary archiving; 2) Local audio/video upload transcription (other forms of offline summary archiving)

<div align="center">
  
  ### 🌐 [Try Live Demo](https://www.aliyun.com/exp/tingwu-agent)
  
  <img src="./docs/images/tingwu-agent.png" alt="Core Features" width="950">
  
  <sub>Click the link above to experience the full features, or view the screenshot below to learn about core capabilities</sub>
  
</div>

## 🚀 Quick Start

### 1. Start the Project and View Results

Follow these steps to start the project:

#### Requirements

- **Node.js**: Version ≥ 18.0.0
- **Package Manager**: npm

#### Startup Steps

1. **Clone the Project**
   Get the project code: git clone or download offline files

2. **Install Dependencies**

   ```bash
   cd tingwu-web
   npm install
   ```

3. **Configure API Keys** (Important!)

   Edit the `.env` file and replace the following configuration with your actual values:

   ```typescript
   // TODO Replace with your own API_KEY and APP_ID
   REACT_APP_API_KEY = xxxxx;
   REACT_APP_APP_ID = xxxxx;
   ```

4. **Start the Development Server**

   ```bash
   npm run start
   ```

5. **View Results**

   Open your browser and visit: `http://localhost:3000`

   The project will automatically open the browser and display the Tingwu AI frontend interface.

### 2. Prerequisites Checklist

Before starting the project, complete the following preparations:

| Step | Instructions                       | URL                                                                                                                 |
| ---- | ---------------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| 1    | **Register Alibaba Cloud Account** | [Alibaba Cloud](https://www.aliyun.com)                                                                             |
| 2    | **Activate Bailian Model Service** | [Bailian Console](https://bailian.console.aliyun.com/?tab=model#/model-market)                                      |
| 3    | **Get API Key**                    | [API Key Management](https://bailian.console.aliyun.com/?tab=model#/api-key)                                        |
| 4    | **Get App ID**                     | [Application Management](https://bailian.console.aliyun.com/?tab=app#/app/app-market/tingwu/tingwu-meeting-summary) |

#### Detailed Steps

**API Key Retrieval Steps:**

1. Log in to [Alibaba Cloud Bailian Console](https://bailian.console.aliyun.com/?tab=model#/api-key)
2. Select "API-KEY" in the left navigation bar
3. Click "Create New API Key"
4. Copy the generated API Key

**App ID Retrieval Steps:**

1. Log in to [Alibaba Cloud Bailian Console](https://bailian.console.aliyun.com/?tab=app#/app/app-market/tingwu/tingwu-meeting-summary)
2. Click "Create Application" to generate your own application
3. Each application card has an "Application ID"

## 🔧 Development Guide

### Project Structure

```
tingwu-web/
├── packages/
│   ├── tingwu-example/     # Example application (main entry point)
│   ├── tingwu-service/     # API service layer
│   ├── tingwu-components/  # Component library
│   ├── tingwu-core/       # Core logic
│   ├── tingwu-summary/   # Tingwu intelligent summary detail page
│   ├── tingwu-home/       # Configuration page for enabling intelligent summary
│   └── ...                # Other packages
```

### Main Commands

- `npm run start`: Start the development server
- `npm run build`: Build production version
- `npm run lint`: Code linting
- `npm run test`: Run tests

## ⚠️ Important Notes

1. **API Key Security**: Do not commit API Keys to the code repository. It is recommended to use environment variables for management
2. **Browser Permissions**: Real-time recording requires browser microphone permissions
3. **Network Requirements**: The project needs to access Alibaba Cloud Bailian services. Please ensure network connectivity is normal
4. **⚠️ Important Notice**: Multiple packages in this project are not published to the public npm registry. If you use them for development, it is recommended to use them as needed. If you need to publish npm packages, you need to rename them yourself

## 👨‍💻 Developer Guide

If you are a developer and need more debugging and in-depth understanding of code implementation, please check:

- **[README-DEV.md](./docs/README-DEV.md)**: Detailed development documentation, including code debugging, architecture description, API interfaces, etc.
- **[Contributing Guide](CONTRIBUTING.en.md)**: Learn how to contribute to the project, including development environment setup, code standards, commit standards, etc.

## 🆘 FAQ

**Q: Blank page after startup?**
A: Please check if API_KEY and APP_ID are correctly configured

**Q: Real-time recording not working?**
A: Please ensure the browser has authorized microphone permissions and use it in an HTTPS environment

**Q: File upload failed?**
A: Please check if the file format is supported and if the API key is valid

## 📞 Technical Support

If you have any questions, please contact the development team or check the project documentation.

## 🤝 Contributing

We welcome all forms of contributions! If you want to participate in the project, please:

- Read the [Contributing Guide](CONTRIBUTING.en.md) ([中文版本](CONTRIBUTING.md)) to learn how to contribute
- Check the [Code of Conduct](CODE_OF_CONDUCT.en.md) ([中文版本](CODE_OF_CONDUCT.md)) to understand community standards

## LICENSE

This project is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

See the full license in the [LICENSE](LICENSE) file.

SPDX-License-Identifier: GPL-3.0-or-later
