# 贡献指南

感谢您对听悟大模型前端项目的关注！我们欢迎所有形式的贡献。

> **注意**: 本文档中的 GitHub 仓库地址为占位符，请根据实际情况替换为您的仓库地址。
>
> [English Version](CONTRIBUTING.en.md) | [中文版本](CONTRIBUTING.md)

## 📋 目录

- [开始之前](#开始之前)
- [贡献流程](#贡献流程)
- [Pull Request 指南](#pull-request-指南)
- [开发环境设置](#开发环境设置)
- [开发流程](#开发流程)
- [代码规范](#代码规范)
- [提交规范](#提交规范)
- [许可证](#许可证)

## 开始之前

### 阅读行为准则

本项目遵循 [贡献者行为准则](CODE_OF_CONDUCT.md) ([English](CODE_OF_CONDUCT.en.md))。参与本项目即表示您同意遵守此准则。请确保在贡献之前仔细阅读并理解这些准则。

### 了解项目

在开始贡献之前，建议您：

- 阅读 [README.md](README.md) 了解项目概述
- 查看 [开发者文档](docs/README-DEV.md) 了解技术细节
- 浏览现有的 Issues 和 Pull Requests，了解项目的开发方向

## 贡献流程

### 报告问题

如果您发现了 bug 或有功能建议，请：

1. **检查现有 Issues**
   
   在创建新 issue 之前，请先检查 [Issues](https://github.com/your-repo/tingwu-web/issues) 中是否已有相关问题。如果存在，您可以在现有 issue 下添加评论。

2. **创建新 Issue**
   
   如果没有相关问题，请创建新 issue，并包含以下信息：
   - **清晰的问题描述**: 简要说明问题或建议
   - **复现步骤**（如果是 bug）: 详细描述如何复现问题
   - **预期行为与实际行为**: 说明您期望的行为和实际发生的行为
   - **环境信息**: Node.js 版本、操作系统、浏览器版本等
   - **截图或日志**（如适用）: 有助于理解问题的视觉信息

3. **Issue 标签**
   
   请为您的 issue 添加适当的标签（如 `bug`、`feature`、`documentation` 等），以便维护者更好地分类和处理。

### 提交代码

#### Fork 和克隆仓库

1. **Fork 项目**
   
   在 GitHub 上 Fork 本项目到您的账户。

2. **克隆您的 Fork**
   ```bash
   git clone https://github.com/your-username/tingwu-web.git
   cd tingwu-web
   ```

3. **添加上游仓库**（可选但推荐）
   ```bash
   git remote add upstream https://github.com/your-repo/tingwu-web.git
   ```

#### 创建分支

为您的更改创建一个新分支：

```bash
git checkout -b feat/your-feature-name
# 或
git checkout -b fix/your-bug-fix
```

**分支命名规范**:
- `feat/`: 新功能
- `fix/`: Bug 修复
- `docs/`: 文档更新
- `refactor/`: 代码重构
- `test/`: 测试相关
- `chore/`: 构建或工具相关

#### 进行开发

1. **编写代码**
   - 遵循项目的代码规范（见下方）
   - 确保代码通过 lint 检查
   - 添加必要的注释

2. **添加测试**（如适用）
   - 为新功能添加单元测试
   - 确保所有测试通过

3. **更新文档**
   - 如果更改了 API 或添加了新功能，请更新相关文档

## Pull Request 指南

为了帮助我们快速审查和合并您的 PR，请遵循以下指南。不符合这些标准的 PR 可能会被关闭。

### 代码审查

所有提交，包括项目成员的提交，都需要经过审查。我们使用 GitHub Pull Requests 进行代码审查。

### Pull Request 指南

#### 1. 关联现有 Issue

所有 PR 应该关联到现有的 issue。这确保了每个更改在编写代码之前都经过讨论，并与项目目标保持一致。

- **Bug 修复**: PR 应该关联到相应的 bug 报告 issue
- **新功能**: PR 应该关联到已获得维护者批准的功能请求或提案 issue
- **如果不存在相关 issue**: 请先创建一个 issue 并等待反馈，然后再开始编码

#### 2. 保持精简和专注

我们倾向于小而原子化的 PR，每个 PR 解决一个问题或添加一个自包含的功能。

✅ **推荐做法**:
- 创建一个修复特定 bug 的 PR
- 创建一个添加特定功能的 PR

❌ **不推荐做法**:
- 将多个不相关的更改（如 bug 修复、新功能和重构）打包到一个 PR 中
- 大型更改应该分解为一系列可以独立审查和合并的小型、逻辑清晰的 PR

#### 3. 使用 Draft PR 进行工作

如果您想获得早期反馈，请使用 GitHub 的 Draft Pull Request 功能。这向维护者表明 PR 尚未准备好进行正式审查，但欢迎讨论和初步反馈。

#### 4. 确保所有检查通过

在提交 PR 之前，请确保所有自动化检查都通过：

```bash
# 运行类型检查
npm run typechecking

# 运行代码检查
npm run lint

# 运行测试
npm run test

# 构建项目
npm run build
```

**提示**: 建议在提交 PR 之前运行这些命令，确保代码质量。

#### 5. 更新文档

如果您的 PR 引入了面向用户的更改（例如新功能、修改的行为或新的配置选项），您还必须更新 `/docs` 目录中的相关文档。

#### 6. 编写清晰的提交信息和 PR 描述

您的 PR 应该有一个清晰、描述性的标题和详细的更改描述。

**提交信息格式**:
- 遵循 [Conventional Commits](https://www.conventionalcommits.org/) 规范
- 使用清晰、简洁的描述

✅ **好的 PR 标题**: `feat(audio): 添加音频播放器组件`
❌ **不好的 PR 标题**: `一些更改`

**PR 描述应包含**:
- 更改的目的和原因（"为什么"）
- 主要变更的列表
- 关联的相关 issue（如 `Fixes #123`）
- 测试说明（如何验证更改）

### PR 模板示例

创建 PR 时，可以使用以下模板：

```markdown
## 变更描述
简要描述本次 PR 的变更内容

## 变更类型
- [ ] 新功能
- [ ] Bug 修复
- [ ] 文档更新
- [ ] 代码重构
- [ ] 性能优化
- [ ] 其他

## 相关 Issue
Closes #123

## 测试说明
描述如何测试这些变更，包括：
- 测试步骤
- 预期结果
- 测试环境

## 检查清单
- [ ] 代码已通过 lint 检查
- [ ] 已添加必要的测试
- [ ] 所有测试通过
- [ ] 文档已更新
- [ ] 已测试所有相关功能
- [ ] 代码已格式化
- [ ] 已关联相关 issue
```

## 开发环境设置

本节指导贡献者如何构建、修改和理解本项目的开发设置。

### 环境要求

- **Node.js**: 版本 ≥ 18.0.0（推荐使用 Node.js 20.x）
- **npm**: 最新版本（或 yarn/pnpm）
- **Git**: 最新版本

### 设置开发环境

#### 1. 克隆仓库

```bash
git clone https://github.com/your-repo/tingwu-web.git
cd tingwu-web
```

#### 2. 安装依赖

```bash
npm install
```

这将安装根目录和所有子包的依赖。

#### 3. 配置环境变量

创建 `.env` 文件（如果不存在）：

```bash
# API 配置
REACT_APP_API_KEY=your_api_key
REACT_APP_APP_ID=your_app_id
```

> **重要**: 请勿将包含真实 API Key 的 `.env` 文件提交到仓库。`.env` 文件应该已经在 `.gitignore` 中。

#### 4. 构建项目

构建所有包：

```bash
npm run build
```

这将编译 TypeScript、打包资源，并准备所有包以供执行。

#### 5. 启动开发服务器

```bash
npm run start
```

访问 `http://localhost:3000` 查看效果。

### 运行测试

本项目包含单元测试。

#### 运行所有测试

```bash
npm run test
```

这将运行所有包的测试。确保在提交更改之前所有测试都通过。

#### 运行特定包的测试

```bash
cd packages/tingwu-core
npm run test
```

### 代码检查和格式化

#### 运行代码检查

```bash
npm run lint
```

这将运行 ESLint 检查所有包的代码。

#### 格式化代码

项目使用 ESLint 和 Prettier 进行代码格式化。大多数编辑器可以配置为在保存时自动格式化。

#### 类型检查

```bash
npm run typechecking
```

这将运行 TypeScript 类型检查。

### 开发单个包

如果需要单独开发某个包：

```bash
cd packages/tingwu-example
npm run dev
```

## 开发流程

### 项目结构

```
tingwu-web/
├── packages/
│   ├── tingwu-example/      # 示例应用（主要启动入口）
│   ├── tingwu-service/      # API 服务层
│   ├── tingwu-components/   # 组件库
│   ├── tingwu-core/         # 核心逻辑
│   ├── tingwu-summary/      # 听悟智能纪要详情页
│   ├── tingwu-home/         # 开启智能纪要的配置页
│   └── ...                  # 其他包
├── docs/                    # 文档目录
├── package.json            # 根配置文件
└── lerna.json              # Lerna 配置
```

### 常用命令

- `npm run start`: 启动开发服务器
- `npm run build`: 构建所有包
- `npm run lint`: 运行代码检查
- `npm run test`: 运行测试
- `npm run typechecking`: 类型检查
- `npm run clean`: 清理构建产物

### 保持分支同步

在开始新工作之前，确保您的分支是最新的：

```bash
# 获取上游更改
git fetch upstream

# 切换到主分支
git checkout main

# 合并上游更改
git merge upstream/main

# 切换回您的功能分支
git checkout feat/your-feature-name

# 将主分支的更改合并到您的分支
git merge main
```

## 代码规范

### 代码风格

- 使用 **TypeScript** 进行开发
- 遵循项目现有的代码风格和模式
- 使用 **ESLint** 和 **Prettier** 进行代码格式化
- 保持代码简洁、可读

### 命名规范

- **组件**: 使用 PascalCase，如 `AudioPlayer.tsx`
- **函数/变量**: 使用 camelCase，如 `handleClick`
- **常量**: 使用 UPPER_SNAKE_CASE，如 `API_BASE_URL`
- **文件**: 使用 camelCase 或 kebab-case
- **类型/接口**: 使用 PascalCase，如 `AudioConfig`

### 导入顺序

```typescript
// 1. React 相关
import React from 'react';
import { useState, useEffect } from 'react';

// 2. 第三方库
import { Button } from "antd";
import dayjs from "dayjs";

// 3. 项目内部模块
import { SomeComponent } from "tingwu-components";
import { someUtil } from "./utils";
```

### 注释规范

- 使用中文注释（与项目现有风格一致）
- 复杂逻辑必须添加注释说明
- 函数和类需要添加 JSDoc 注释

```typescript
/**
 * 处理音频播放
 * @param url 音频文件地址
 * @param options 播放选项
 * @returns 播放器实例
 */
function handleAudioPlay(url: string, options?: PlayOptions): AudioPlayer {
  // 实现逻辑
}
```

### 文件组织

- 每个组件应该有独立的文件
- 相关的工具函数应该组织在 `utils` 目录中
- 类型定义应该放在 `types` 目录或与相关代码一起

## 提交规范

### Commit Message 格式

我们使用 [Conventional Commits](https://www.conventionalcommits.org/) 规范：

```
<type>(<scope>): <subject>

<body>

<footer>
```

### Type 类型

- `feat`: 新功能
- `fix`: 修复 bug
- `docs`: 文档更新
- `style`: 代码格式调整（不影响功能）
- `refactor`: 代码重构
- `test`: 测试相关
- `chore`: 构建过程或辅助工具的变动
- `perf`: 性能优化

### Scope（可选）

指定更改影响的范围，如 `audio`、`transcription`、`components` 等。

### 示例

```bash
# 新功能
git commit -m "feat(audio): 添加音频播放器组件"

# 修复 bug
git commit -m "fix(transcription): 修复实时转录断线重连问题"

# 文档更新
git commit -m "docs: 更新 README 中的安装说明"

# 代码重构
git commit -m "refactor(core): 重构音频处理逻辑"
```

## 许可证

通过贡献代码，您同意您的贡献将在 [GPL-3.0-or-later](LICENSE) 许可证下发布。

## 获取帮助

如果您在贡献过程中遇到问题：

1. 查看 [README.md](README.md) 和 [docs/README-DEV.md](docs/README-DEV.md)
2. 在 GitHub Issues 中搜索相关问题
3. 创建新 issue 寻求帮助
4. 查看现有的 Pull Requests 和讨论

## 致谢

感谢所有为听悟项目做出贡献的开发者！🎉

您的贡献使这个项目变得更好。我们感谢您的时间和努力。
