# Contributing Guide

Thank you for your interest in the Tingwu AI Frontend Project! We welcome contributions of all kinds.

> **Note**: The GitHub repository URLs in this document are placeholders. Please replace them with your actual repository address.
>
> [English Version](CONTRIBUTING.en.md) | [中文版本](CONTRIBUTING.md)

## 📋 Table of Contents

- [Before You Begin](#before-you-begin)
- [Contribution Process](#contribution-process)
- [Pull Request Guidelines](#pull-request-guidelines)
- [Development Environment Setup](#development-environment-setup)
- [Development Workflow](#development-workflow)
- [Code Standards](#code-standards)
- [Commit Standards](#commit-standards)
- [License](#license)

## Before You Begin

### Read the Code of Conduct

This project follows the [Contributor Code of Conduct](CODE_OF_CONDUCT.en.md) ([中文版本](CODE_OF_CONDUCT.md)). By participating, you are expected to uphold this code. Please make sure to read and understand these guidelines before contributing.

### Understand the Project

Before you begin contributing, we recommend:

- Reading [README.md](README.md) to understand the project overview
- Reviewing the [Developer Documentation](docs/README-DEV.md) for technical details
- Browsing existing Issues and Pull Requests to understand the project's development direction

## Contribution Process

### Reporting Issues

If you find a bug or have a feature suggestion, please:

1. **Check Existing Issues**
   
   Before creating a new issue, please check [Issues](https://github.com/your-repo/tingwu-web/issues) to see if a similar issue already exists. If one exists, you can add a comment to the existing issue.

2. **Create a New Issue**
   
   If no similar issue exists, create a new issue with the following information:
   - **Clear problem description**: Briefly describe the problem or suggestion
   - **Steps to reproduce** (if it's a bug): Detailed steps on how to reproduce the issue
   - **Expected vs actual behavior**: Explain what you expected and what actually happened
   - **Environment information**: Node.js version, operating system, browser version, etc.
   - **Screenshots or logs** (if applicable): Visual information that helps understand the issue

3. **Issue Labels**
   
   Please add appropriate labels to your issue (such as `bug`, `feature`, `documentation`, etc.) to help maintainers better categorize and handle them.

### Submitting Code

#### Fork and Clone the Repository

1. **Fork the Project**
   
   Fork this project to your account on GitHub.

2. **Clone Your Fork**
   ```bash
   git clone https://github.com/your-username/tingwu-web.git
   cd tingwu-web
   ```

3. **Add Upstream Repository** (optional but recommended)
   ```bash
   git remote add upstream https://github.com/your-repo/tingwu-web.git
   ```

#### Create a Branch

Create a new branch for your changes:

```bash
git checkout -b feat/your-feature-name
# or
git checkout -b fix/your-bug-fix
```

**Branch Naming Conventions**:
- `feat/`: New feature
- `fix/`: Bug fix
- `docs/`: Documentation update
- `refactor/`: Code refactoring
- `test/`: Test related
- `chore/`: Build or tool related

#### Make Your Changes

1. **Write Code**
   - Follow the project's code standards (see below)
   - Ensure code passes lint checks
   - Add necessary comments

2. **Add Tests** (if applicable)
   - Add unit tests for new features
   - Ensure all tests pass

3. **Update Documentation**
   - If you changed APIs or added new features, update relevant documentation

## Pull Request Guidelines

To help us review and merge your PRs quickly, please follow these guidelines. PRs that do not meet these standards may be closed.

### Code Reviews

All submissions, including submissions by project members, require review. We use GitHub Pull Requests for this purpose.

### Pull Request Guidelines

#### 1. Link to an Existing Issue

All PRs should be linked to an existing issue. This ensures that every change has been discussed and is aligned with the project's goals before any code is written.

- **Bug fixes**: The PR should be linked to the bug report issue
- **New features**: The PR should be linked to the feature request or proposal issue that has been approved by a maintainer
- **If an issue doesn't exist**: Please open one first and wait for feedback before you start coding

#### 2. Keep It Small and Focused

We favor small, atomic PRs that address a single issue or add a single, self-contained feature.

✅ **Do**:
- Create a PR that fixes one specific bug
- Create a PR that adds one specific feature

❌ **Don't**:
- Bundle multiple unrelated changes (e.g., a bug fix, a new feature, and a refactor) into a single PR
- Large changes should be broken down into a series of smaller, logical PRs that can be reviewed and merged independently

#### 3. Use Draft PRs for Work in Progress

If you'd like to get early feedback on your work, please use GitHub's Draft Pull Request feature. This signals to the maintainers that the PR is not yet ready for a formal review but is open for discussion and initial feedback.

#### 4. Ensure All Checks Pass

Before submitting your PR, ensure that all automated checks are passing:

```bash
# Run type checking
npm run typechecking

# Run code linting
npm run lint

# Run tests
npm run test

# Build the project
npm run build
```

**Tip**: It's recommended to run these commands before submitting a PR to ensure code quality.

#### 5. Update Documentation

If your PR introduces a user-facing change (e.g., a new feature, modified behavior, or new configuration options), you must also update the relevant documentation in the `/docs` directory.

#### 6. Write Clear Commit Messages and a Good PR Description

Your PR should have a clear, descriptive title and a detailed description of the changes.

**Commit Message Format**:
- Follow the [Conventional Commits](https://www.conventionalcommits.org/) specification
- Use clear, concise descriptions

✅ **Good PR Title**: `feat(audio): add audio player component`
❌ **Bad PR Title**: `some changes`

**PR Description Should Include**:
- The purpose and reason for the changes (the "why")
- A list of main changes
- Link to related issues (e.g., `Fixes #123`)
- Testing instructions (how to verify the changes)

### PR Template Example

When creating a PR, you can use the following template:

```markdown
## Change Description
Briefly describe the changes in this PR

## Change Type
- [ ] New feature
- [ ] Bug fix
- [ ] Documentation update
- [ ] Code refactoring
- [ ] Performance optimization
- [ ] Other

## Related Issue
Closes #123

## Testing Instructions
Describe how to test these changes, including:
- Test steps
- Expected results
- Test environment

## Checklist
- [ ] Code passes lint checks
- [ ] Necessary tests added
- [ ] All tests pass
- [ ] Documentation updated
- [ ] All related features tested
- [ ] Code formatted
- [ ] Related issue linked
```

## Development Environment Setup

This section guides contributors on how to build, modify, and understand the development setup of this project.

### Requirements

- **Node.js**: Version ≥ 18.0.0 (Node.js 20.x recommended)
- **npm**: Latest version (or yarn/pnpm)
- **Git**: Latest version

### Setting Up the Development Environment

#### 1. Clone the Repository

```bash
git clone https://github.com/your-repo/tingwu-web.git
cd tingwu-web
```

#### 2. Install Dependencies

```bash
npm install
```

This will install dependencies for the root directory and all sub-packages.

#### 3. Configure Environment Variables

Create a `.env` file (if it doesn't exist):

```bash
# API Configuration
REACT_APP_API_KEY=your_api_key
REACT_APP_APP_ID=your_app_id
```

> **Important**: Do not commit the `.env` file containing real API keys to the repository. The `.env` file should already be in `.gitignore`.

#### 4. Build the Project

Build all packages:

```bash
npm run build
```

This will compile TypeScript, bundle assets, and prepare all packages for execution.

#### 5. Start the Development Server

```bash
npm run start
```

Visit `http://localhost:3000` to see the result.

### Running Tests

This project includes unit tests.

#### Run All Tests

```bash
npm run test
```

This will run tests for all packages. Make sure all tests pass before submitting changes.

#### Run Tests for a Specific Package

```bash
cd packages/tingwu-core
npm run test
```

### Code Linting and Formatting

#### Run Code Linting

```bash
npm run lint
```

This will run ESLint to check code for all packages.

#### Format Code

The project uses ESLint and Prettier for code formatting. Most editors can be configured to automatically format on save.

#### Type Checking

```bash
npm run typechecking
```

This will run TypeScript type checking.

### Developing a Single Package

If you need to develop a specific package:

```bash
cd packages/tingwu-example
npm run dev
```

## Development Workflow

### Project Structure

```
tingwu-web/
├── packages/
│   ├── tingwu-example/      # Example application (main entry point)
│   ├── tingwu-service/      # API service layer
│   ├── tingwu-components/   # Component library
│   ├── tingwu-core/         # Core logic
│   ├── tingwu-summary/      # Tingwu intelligent summary detail page
│   ├── tingwu-home/         # Configuration page for enabling intelligent summary
│   └── ...                  # Other packages
├── docs/                    # Documentation directory
├── package.json            # Root configuration file
└── lerna.json              # Lerna configuration
```

### Common Commands

- `npm run start`: Start the development server
- `npm run build`: Build all packages
- `npm run lint`: Run code linting
- `npm run test`: Run tests
- `npm run typechecking`: Type checking
- `npm run clean`: Clean build artifacts

### Keeping Your Branch in Sync

Before starting new work, make sure your branch is up to date:

```bash
# Fetch upstream changes
git fetch upstream

# Switch to main branch
git checkout main

# Merge upstream changes
git merge upstream/main

# Switch back to your feature branch
git checkout feat/your-feature-name

# Merge main branch changes into your branch
git merge main
```

## Code Standards

### Code Style

- Use **TypeScript** for development
- Follow the existing code style and patterns in the project
- Use **ESLint** and **Prettier** for code formatting
- Keep code simple and readable

### Naming Conventions

- **Components**: Use PascalCase, e.g., `AudioPlayer.tsx`
- **Functions/Variables**: Use camelCase, e.g., `handleClick`
- **Constants**: Use UPPER_SNAKE_CASE, e.g., `API_BASE_URL`
- **Files**: Use camelCase or kebab-case
- **Types/Interfaces**: Use PascalCase, e.g., `AudioConfig`

### Import Order

```typescript
// 1. React related
import React from 'react';
import { useState, useEffect } from 'react';

// 2. Third-party libraries
import { Button } from "antd";
import dayjs from "dayjs";

// 3. Internal project modules
import { SomeComponent } from "tingwu-components";
import { someUtil } from "./utils";
```

### Comment Standards

- Use English comments (consistent with project style)
- Complex logic must include comments
- Functions and classes need JSDoc comments

```typescript
/**
 * Handle audio playback
 * @param url Audio file URL
 * @param options Playback options
 * @returns Player instance
 */
function handleAudioPlay(url: string, options?: PlayOptions): AudioPlayer {
  // Implementation logic
}
```

### File Organization

- Each component should have its own file
- Related utility functions should be organized in `utils` directories
- Type definitions should be placed in `types` directories or alongside related code

## Commit Standards

### Commit Message Format

We use the [Conventional Commits](https://www.conventionalcommits.org/) specification:

```
<type>(<scope>): <subject>

<body>

<footer>
```

### Type Types

- `feat`: New feature
- `fix`: Bug fix
- `docs`: Documentation updates
- `style`: Code style changes (formatting, missing semicolons, etc.)
- `refactor`: Code refactoring
- `test`: Test related
- `chore`: Build process or auxiliary tool changes
- `perf`: Performance optimization

### Scope (Optional)

Specify the scope affected by the change, such as `audio`, `transcription`, `components`, etc.

### Examples

```bash
# New feature
git commit -m "feat(audio): add audio player component"

# Bug fix
git commit -m "fix(transcription): fix real-time transcription reconnection issue"

# Documentation update
git commit -m "docs: update installation instructions in README"

# Code refactoring
git commit -m "refactor(core): refactor audio processing logic"
```

## License

By contributing, you agree that your contributions will be licensed under the [GPL-3.0-or-later](LICENSE) license.

## Getting Help

If you encounter problems while contributing:

1. Check [README.md](README.md) and [docs/README-DEV.md](docs/README-DEV.md)
2. Search for related issues in GitHub Issues
3. Create a new issue to seek help
4. Review existing Pull Requests and discussions

## Acknowledgments

Thank you to all developers who contribute to the Tingwu project! 

Your contributions make this project better. We appreciate your time and effort.
