/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.jar.Manifest;
import org.apache.flink.util.JavaVersion;
import org.apache.flink.util.SystemUtils;

public final class CompressionUtil {
    public static final byte[] MAGIC = new byte[]{10, 17, -70, -70};
    private static boolean nativeLibraryLoaded = false;
    public static boolean nativeLibraryAvailable;
    private static File tmpDir;

    public static ProtectionDomain getProtectionDomain(String var0, URLClassLoader var1) {
        try {
            String var2 = var0.replace('.', '/').concat(".class");
            Field var3 = URLClassLoader.class.getDeclaredField("ucp");
            var3.setAccessible(true);
            Object var4 = var3.get(var1);
            Method var5 = var4.getClass().getDeclaredMethod("getResource", String.class, Boolean.TYPE);
            Object var6 = var5.invoke(var4, var2, false);
            if (var6 == null) {
                return null;
            }
            Method var7 = var6.getClass().getDeclaredMethod("getCodeSourceURL", new Class[0]);
            var7.setAccessible(true);
            URL var8 = (URL)var7.invoke(var6, new Object[0]);
            Method var9 = var6.getClass().getDeclaredMethod("getCodeSigners", new Class[0]);
            var9.setAccessible(true);
            CodeSigner[] var10 = (CodeSigner[])var9.invoke(var6, new Object[0]);
            CodeSource var11 = new CodeSource(var8, var10);
            Method var12 = SecureClassLoader.class.getDeclaredMethod("getProtectionDomain", CodeSource.class);
            var12.setAccessible(true);
            return (ProtectionDomain)var12.invoke((Object)var1, var11);
        }
        catch (Throwable var13) {
            throw new RuntimeException(var13);
        }
    }

    public static void definePackage(String var0, URLClassLoader var1) {
        block9: {
            try {
                String var2 = var0.replace('.', '/').concat(".class");
                Field var3 = URLClassLoader.class.getDeclaredField("ucp");
                var3.setAccessible(true);
                Object var4 = var3.get(var1);
                Method var5 = var4.getClass().getDeclaredMethod("getResource", String.class, Boolean.TYPE);
                Object var6 = var5.invoke(var4, var2, false);
                if (var6 == null) break block9;
                Method var7 = var6.getClass().getDeclaredMethod("getCodeSourceURL", new Class[0]);
                var7.setAccessible(true);
                URL var8 = (URL)var7.invoke(var6, new Object[0]);
                int var9 = var0.lastIndexOf(46);
                if (var9 == -1) break block9;
                String var10 = var0.substring(0, var9);
                Method var11 = var6.getClass().getDeclaredMethod("getManifest", new Class[0]);
                var11.setAccessible(true);
                Manifest var12 = (Manifest)var11.invoke(var6, new Object[0]);
                if (SystemUtils.isJavaVersionAtMost(JavaVersion.JAVA_1_8)) {
                    Method var13 = URLClassLoader.class.getDeclaredMethod("definePackageInternal", String.class, Manifest.class, URL.class);
                    var13.setAccessible(true);
                    var13.invoke((Object)var1, var10, var12, var8);
                    break block9;
                }
                Method var13 = URLClassLoader.class.getDeclaredMethod("getAndVerifyPackage", String.class, Manifest.class, URL.class);
                var13.setAccessible(true);
                Method var14 = URLClassLoader.class.getDeclaredMethod("definePackage", String.class, Manifest.class, URL.class);
                var14.setAccessible(true);
                Method var15 = ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
                var15.setAccessible(true);
                if (var13.invoke((Object)var1, var10, var12, var8) != null) break block9;
                try {
                    if (var12 != null) {
                        var14.invoke((Object)var1, var10, var12, var8);
                    } else {
                        var15.invoke((Object)var1, var10, null, null, null, null, null, null, null);
                    }
                }
                catch (InvocationTargetException var17) {
                    if (!(var17.getCause() instanceof IllegalArgumentException)) {
                        throw var17;
                    }
                    if (var13.invoke((Object)var1, var10, var12, var8) == null) {
                        throw new AssertionError((Object)("Cannot find package " + var10));
                    }
                }
            }
            catch (Throwable var18) {
                throw new RuntimeException(var18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryFromJar() throws Exception {
        if (!nativeLibraryLoaded) {
            String var0 = CompressionUtil.getCompressionLibraryPath();
            try (InputStream var1 = CompressionUtil.class.getResourceAsStream(var0);){
                String[] var2;
                String var3;
                if (var1 == null) {
                    throw new FileNotFoundException("Compression library " + var0 + " not found");
                }
                if (tmpDir == null) {
                    tmpDir = CompressionUtil.createTmpFile("ververica-classloader-library");
                    tmpDir.deleteOnExit();
                }
                String string = var3 = (var2 = var0.split("/")).length < 1 ? null : var2[var2.length - 1];
                if (var3 == null || var3.isEmpty()) {
                    throw new IllegalArgumentException("Invalid library path: " + var0);
                }
                File var4 = new File(tmpDir, var3);
                try {
                    Files.copy(var1, var4.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception var13) {
                    if (var4.exists()) {
                        var4.delete();
                    }
                    throw var13;
                }
                try {
                    System.load(var4.getAbsolutePath());
                    nativeLibraryLoaded = true;
                }
                finally {
                    if (CompressionUtil.isPosixCompliant()) {
                        var4.delete();
                    } else {
                        var4.deleteOnExit();
                    }
                }
            }
        }
    }

    private static String getCompressionLibraryPath() {
        String var1;
        String var0;
        if (SystemUtils.IS_OS_LINUX) {
            var0 = "linux";
            var1 = "libflink-compression.so";
        } else if (!SystemUtils.IS_OS_MAC && !SystemUtils.IS_OS_MAC_OSX) {
            if (SystemUtils.IS_OS_WINDOWS) {
                var0 = "windows";
                var1 = "flink-compression.dll";
            } else {
                var0 = "UnsupportedPlatform";
                var1 = "flink-compression";
            }
        } else {
            var0 = "mac";
            var1 = "libflink-compression.dylib";
        }
        String var2 = System.getProperty("os.arch");
        return "native/" + var0 + "/" + var2 + "/" + var1;
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (Exception var1) {
            return false;
        }
    }

    private static File createTmpFile(String var0) throws IOException {
        File var1 = new File(System.getProperty("java.io.tmpdir"), var0 + System.nanoTime());
        if (!var1.mkdirs()) {
            throw new IOException("Cannot mkdirs: " + var1.getAbsolutePath());
        }
        return var1;
    }

    static {
        tmpDir = null;
        try {
            CompressionUtil.loadLibraryFromJar();
            nativeLibraryAvailable = true;
        }
        catch (Exception var1) {
            nativeLibraryAvailable = false;
        }
    }
}

