/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.function.Consumer;
import org.apache.flink.util.CompressionUtil;
import org.apache.flink.util.Compressor;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.MutableURLClassLoader;

public class CompressionSerializer
extends FlinkUserCodeClassLoader {
    private final Compressor compressor = new Compressor();

    public CompressionSerializer(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    protected CompressionSerializer(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
        super(urls, parent, classLoadingExceptionHandler);
    }

    public MutableURLClassLoader copy() {
        return new CompressionSerializer(this.getURLs(), this.getParent());
    }

    protected Class<?> findClass(String var1) throws ClassNotFoundException {
        try {
            return super.findClass(var1);
        }
        catch (ClassFormatError var7) {
            if (CompressionUtil.nativeLibraryAvailable) {
                String var3 = var1.replace('.', '/').concat(".class");
                URL var4 = this.findResource(var3);
                if (var4 == null) {
                    throw new ClassNotFoundException(var1);
                }
                byte[] var5 = this.compressor.decompressClass(var4, var1, var7);
                ProtectionDomain var6 = CompressionUtil.getProtectionDomain(var1, (URLClassLoader)((Object)this));
                return this.defineClass(var1, var5, 0, var5.length, var6);
            }
            throw var7;
        }
    }

    protected Class<?> loadClassWithoutExceptionHandling(String var1, boolean var2) throws ClassNotFoundException {
        try {
            return super.loadClassWithoutExceptionHandling(var1, var2);
        }
        catch (ClassFormatError var9) {
            if (CompressionUtil.nativeLibraryAvailable) {
                String var4 = var1.replace('.', '/').concat(".class");
                URL var5 = this.getResource(var4);
                if (var5 == null) {
                    throw new ClassNotFoundException(var1);
                }
                byte[] var6 = this.compressor.decompressClass(var5, var1, var9);
                ProtectionDomain var7 = CompressionUtil.getProtectionDomain(var1, (URLClassLoader)((Object)this));
                Class var8 = this.defineClass(var1, var6, 0, var6.length, var7);
                if (var2) {
                    this.resolveClass(var8);
                }
                return var8;
            }
            throw var9;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

