#!/bin/bash

# CosyVoice Flask 一键启动脚本
# 作者: Auto Generated
# 日期: 2026-02-02

# 设置颜色输出
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# 获取脚本所在目录（cosyvoiceFlask）
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$SCRIPT_DIR"

echo -e "${BLUE}========================================${NC}"
echo -e "${BLUE}  CosyVoice Flask 一键启动脚本${NC}"
echo -e "${BLUE}========================================${NC}"
echo ""

# 1. 检查 Python3 是否安装
echo -e "${YELLOW}[1/5] 检查 Python 环境...${NC}"
if ! command -v python3 &> /dev/null; then
    echo -e "${RED}❌ 错误: 未找到 Python3，请先安装 Python 3.7+${NC}"
    exit 1
fi
PYTHON_VERSION=$(python3 --version 2>&1 | awk '{print $2}')
echo -e "${GREEN}✓ Python 版本: $PYTHON_VERSION${NC}"
echo ""

# 2. 获取 API Key
echo -e "${YELLOW}[2/5] 检查 DASHSCOPE_API_KEY...${NC}"
if [ -z "$DASHSCOPE_API_KEY" ]; then
    echo -e "${YELLOW}⚠ 环境变量 DASHSCOPE_API_KEY 未设置${NC}"
    echo -e "${YELLOW}→ 运行 get_api_key.py 查看获取指引...${NC}"
    echo ""

    python3 get_api_key.py

    echo ""
    echo -e "${YELLOW}请输入你的 DASHSCOPE_API_KEY (或按 Ctrl+C 取消):${NC}"
    read -r API_KEY_INPUT
    if [ -n "$API_KEY_INPUT" ]; then
        export DASHSCOPE_API_KEY="$API_KEY_INPUT"
        echo -e "${GREEN}✓ API Key 已设置${NC}"
    else
        echo -e "${RED}❌ 错误: API Key 不能为空${NC}"
        echo -e "${YELLOW}提示: 运行 'python3 get_api_key.py' 查看获取方法${NC}"
        exit 1
    fi
else
    echo -e "${GREEN}✓ API Key 已设置 (来自环境变量)${NC}"
fi
echo ""

# 3. 检查并安装依赖
echo -e "${YELLOW}[3/5] 检查 Python 依赖...${NC}"

# 检查 requirements.txt 是否存在
if [ ! -f "requirements.txt" ]; then
    echo -e "${YELLOW}⚠ 未找到 requirements.txt，正在创建...${NC}"
    cat > requirements.txt <<EOF
flask>=2.3.0
python-socketio>=5.9.0
websocket-client>=1.6.0
EOF
    echo -e "${GREEN}✓ requirements.txt 已创建${NC}"
fi

# 检查依赖是否已安装
MISSING_DEPS=0
for pkg in flask python-socketio websocket-client; do
    if ! python3 -c "import ${pkg//-/_}" 2>/dev/null; then
        MISSING_DEPS=1
        break
    fi
done

if [ $MISSING_DEPS -eq 1 ]; then
    echo -e "${YELLOW}→ 正在安装依赖包...${NC}"
    pip3 install -r requirements.txt
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓ 依赖安装成功${NC}"
    else
        echo -e "${RED}❌ 依赖安装失败，请手动运行: pip3 install -r requirements.txt${NC}"
        exit 1
    fi
else
    echo -e "${GREEN}✓ 所有依赖已安装${NC}"
fi
echo ""

# 4. 检查端口占用
echo -e "${YELLOW}[4/5] 检查端口占用...${NC}"
PORT=9000
if lsof -Pi :$PORT -sTCP:LISTEN -t >/dev/null 2>&1; then
    echo -e "${RED}❌ 端口 $PORT 已被占用${NC}"
    echo -e "${YELLOW}占用进程信息:${NC}"
    lsof -i :$PORT
    echo ""
    echo -e "${YELLOW}是否终止占用进程并继续? (y/n)${NC}"
    read -r KILL_PROCESS
    if [ "$KILL_PROCESS" = "y" ] || [ "$KILL_PROCESS" = "Y" ]; then
        PID=$(lsof -ti :$PORT)
        kill -9 $PID 2>/dev/null
        sleep 1
        echo -e "${GREEN}✓ 已终止进程 (PID: $PID)${NC}"
    else
        echo -e "${RED}启动已取消${NC}"
        exit 1
    fi
else
    echo -e "${GREEN}✓ 端口 $PORT 可用${NC}"
fi
echo ""

# 5. 启动服务
echo -e "${YELLOW}[5/5] 启动 Flask 服务...${NC}"
echo -e "${GREEN}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo -e "${GREEN}  服务启动中...${NC}"
echo -e "${GREEN}  访问地址: ${BLUE}http://localhost:$PORT${NC}"
echo -e "${GREEN}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo ""
echo -e "${YELLOW}提示: 按 Ctrl+C 可停止服务${NC}"
echo ""

# 启动 Flask 应用
python3 my_cosyvoice_websocket_server.py
